/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;

public class HttpResponseEncoder
extends HttpObjectEncoder<HttpResponse> {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        void var2_2;
        Class<?> msgClass = msg.getClass();
        if (msgClass == DefaultFullHttpResponse.class || var2_2 == DefaultHttpResponse.class) {
            return true;
        }
        return super.acceptOutboundMessage(msg) && !(var1_1 instanceof HttpRequest);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpResponse response) throws Exception {
        void var1_1;
        void var2_2;
        response.protocolVersion().encode(buf);
        buf.writeByte(32);
        var2_2.status().encode(buf);
        ByteBufUtil.writeShortBE((ByteBuf)var1_1, (int)3338);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void sanitizeHeadersBeforeEncode(HttpResponse msg, boolean isAlwaysEmpty) {
        if (isAlwaysEmpty) {
            void var2_3;
            HttpResponseStatus status = msg.status();
            if (status.codeClass() == HttpStatusClass.INFORMATIONAL || status.code() == HttpResponseStatus.NO_CONTENT.code()) {
                msg.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                msg.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                return;
            }
            if (var2_3.code() == HttpResponseStatus.RESET_CONTENT.code()) {
                void var1_1;
                msg.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                var1_1.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        void var2_2;
        HttpResponseStatus status = msg.status();
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            if (status.code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                void var1_1;
                return var1_1.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            }
            return true;
        }
        return status.code() == HttpResponseStatus.NO_CONTENT.code() || status.code() == HttpResponseStatus.NOT_MODIFIED.code() || var2_2.code() == HttpResponseStatus.RESET_CONTENT.code();
    }
}

