/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return super.acceptOutboundMessage(msg) && !(var1_1 instanceof HttpResponse);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
        void var1_1;
        void var2_2;
        ByteBufUtil.copy((AsciiString)request.method().asciiName(), (ByteBuf)buf);
        String uri = request.uri();
        if (uri.isEmpty()) {
            ByteBufUtil.writeMediumBE((ByteBuf)buf, (int)0x202F20);
        } else {
            CharSequence uriCharSequence = uri;
            boolean needSlash = false;
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int index = uri.indexOf(63, start += 3);
                if (index == -1) {
                    if (uri.lastIndexOf(47) < start) {
                        needSlash = true;
                    }
                } else if (uri.lastIndexOf(47, index) < start) {
                    void var3_3;
                    uriCharSequence = new StringBuilder((String)var3_3).insert(index, '/');
                }
            }
            buf.writeByte(32).writeCharSequence(uriCharSequence, CharsetUtil.UTF_8);
            if (needSlash) {
                ByteBufUtil.writeShortBE((ByteBuf)buf, (int)12064);
            } else {
                buf.writeByte(32);
            }
        }
        var2_2.protocolVersion().encode(buf);
        ByteBufUtil.writeShortBE((ByteBuf)var1_1, (int)3338);
    }
}

