/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersEncoder;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<Object> {
    private static final int COPY_CONTENT_THRESHOLD = 128;
    static final int CRLF_SHORT = 3338;
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)2).writeByte(13).writeByte(10)).asReadOnly();
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF)).asReadOnly();
    private static final float HEADERS_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_WEIGHT_HISTORICAL = 0.8f;
    private static final float TRAILERS_WEIGHT_NEW = 0.2f;
    private static final float TRAILERS_WEIGHT_HISTORICAL = 0.8f;
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private static final int ST_CONTENT_ALWAYS_EMPTY = 3;
    private int state = 0;
    private float headersEncodedSizeAccumulator = 256.0f;
    private float trailersEncodedSizeAccumulator = 256.0f;
    private final List<Object> out = new ArrayList<Object>();

    private static boolean checkContentState(int state) {
        int n;
        return state == 2 || state == 1 || n == 3;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            if (this.acceptOutboundMessage(msg)) {
                this.encode(ctx, msg, this.out);
                if (this.out.isEmpty()) {
                    throw new EncoderException(StringUtil.simpleClassName((Object)((Object)this)) + " must produce at least one message.");
                }
            } else {
                ctx.write(msg, promise);
            }
        }
        catch (EncoderException encoderException) {
            try {
                msg = encoderException;
                throw encoderException;
                catch (Throwable t) {
                    void var2_3;
                    throw new EncoderException((Throwable)var2_3);
                }
            }
            catch (Throwable throwable) {
                void var3_5;
                void var1_1;
                HttpObjectEncoder.writeOutList((ChannelHandlerContext)var1_1, this.out, (ChannelPromise)var3_5);
                throw throwable;
            }
        }
        HttpObjectEncoder.writeOutList(ctx, this.out, promise);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeOutList(ChannelHandlerContext ctx, List<Object> out, ChannelPromise promise) {
        int size = out.size();
        try {
            void var3_4;
            if (size == 1) {
                ctx.write(out.get(0), promise);
            } else if (var3_4 > true) {
                if (promise == ctx.voidPromise()) {
                    HttpObjectEncoder.writeVoidPromise(ctx, out);
                } else {
                    void var2_3;
                    ChannelHandlerContext channelHandlerContext;
                    HttpObjectEncoder.writePromiseCombiner(channelHandlerContext, out, (ChannelPromise)var2_3);
                }
            }
            out.clear();
            return;
        }
        catch (Throwable throwable) {
            void var1_2;
            var1_2.clear();
            throw throwable;
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext ctx, List<Object> out) {
        ChannelPromise voidPromise = ctx.voidPromise();
        for (int i = 0; i < out.size(); ++i) {
            ctx.write(out.get(i), voidPromise);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writePromiseCombiner(ChannelHandlerContext ctx, List<Object> out, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        for (int i = 0; i < out.size(); ++i) {
            combiner.add((Future)ctx.write(out.get(i)));
        }
        var3_3.finish((Promise)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        HttpMessage m;
        void var1_1;
        if (msg == Unpooled.EMPTY_BUFFER) {
            out.add(Unpooled.EMPTY_BUFFER);
            return;
        }
        if (msg instanceof FullHttpMessage) {
            this.encodeFullHttpMessage(ctx, msg, out);
            return;
        }
        if (!(msg instanceof HttpMessage)) {
            void var3_4;
            void var2_3;
            this.encodeNotHttpMessageContentTypes((ChannelHandlerContext)var1_1, var2_3, (List<Object>)var3_4);
            return;
        }
        try {
            m = (HttpMessage)msg;
        }
        catch (Exception rethrow) {
            void var1_2;
            ReferenceCountUtil.release((Object)msg);
            throw var1_2;
        }
        if (m instanceof LastHttpContent) {
            this.encodeHttpMessageLastContent((ChannelHandlerContext)var1_1, m, out);
            return;
        }
        if (m instanceof HttpContent) {
            this.encodeHttpMessageNotLastContent((ChannelHandlerContext)var1_1, m, out);
            return;
        }
        this.encodeJustHttpMessage((ChannelHandlerContext)var1_1, m, out);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeJustHttpMessage(ChannelHandlerContext ctx, H m, List<Object> out) throws Exception {
        assert (!(m instanceof HttpContent));
        try {
            void var1_1;
            void var3_4;
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(m, this.state);
            }
            ByteBuf buf = this.encodeInitHttpMessage(ctx, m);
            assert (HttpObjectEncoder.checkContentState(this.state));
            var3_4.add(var1_1);
        }
        catch (Throwable throwable) {
            void var2_3;
            ReferenceCountUtil.release((Object)var2_3);
            throw throwable;
        }
        ReferenceCountUtil.release(m);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeByteBufHttpContent(int state, ChannelHandlerContext ctx, ByteBuf buf, ByteBuf content, HttpHeaders trailingHeaders, List<Object> out) {
        switch (state) {
            case 1: {
                if (HttpObjectEncoder.encodeContentNonChunk(out, buf, content)) break;
            }
            case 3: {
                out.add(buf);
                return;
            }
            case 2: {
                void var2_2;
                void var3_3;
                out.add(var3_3);
                this.encodeChunkedHttpContent((ChannelHandlerContext)var2_2, content, trailingHeaders, out);
                return;
            }
            default: {
                throw new Error();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeHttpMessageNotLastContent(ChannelHandlerContext ctx, H m, List<Object> out) throws Exception {
        assert (m instanceof HttpContent);
        assert (!(m instanceof LastHttpContent));
        HttpContent httpContent = (HttpContent)m;
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(m, this.state);
            }
            ByteBuf buf = this.encodeInitHttpMessage(ctx, m);
            assert (HttpObjectEncoder.checkContentState(this.state));
            HttpObjectEncoder httpObjectEncoder = this;
            httpObjectEncoder.encodeByteBufHttpContent(httpObjectEncoder.state, (ChannelHandlerContext)var1_1, (ByteBuf)var2_3, httpContent.content(), null, (List<Object>)var3_4);
            return;
        }
        finally {
            httpContent.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeHttpMessageLastContent(ChannelHandlerContext ctx, H m, List<Object> out) throws Exception {
        assert (m instanceof LastHttpContent);
        LastHttpContent httpContent = (LastHttpContent)m;
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(m, this.state);
            }
            ByteBuf buf = this.encodeInitHttpMessage(ctx, m);
            assert (HttpObjectEncoder.checkContentState(this.state));
            HttpObjectEncoder httpObjectEncoder = this;
            httpObjectEncoder.encodeByteBufHttpContent(httpObjectEncoder.state, (ChannelHandlerContext)var1_1, (ByteBuf)var2_3, httpContent.content(), httpContent.trailingHeaders(), (List<Object>)var3_4);
            this.state = 0;
            return;
        }
        finally {
            httpContent.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeNotHttpMessageContentTypes(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        assert (!(msg instanceof HttpMessage));
        if (this.state == 0) {
            try {
                if (msg instanceof ByteBuf && HttpObjectEncoder.bypassEncoderIfEmpty((ByteBuf)msg, out)) {
                    return;
                }
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(msg, 0);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.state = HttpObjectEncoder.encodeEmptyLastHttpContent(this.state, out);
            return;
        }
        if (msg instanceof LastHttpContent) {
            this.encodeLastHttpContent(ctx, (LastHttpContent)msg, out);
            return;
        }
        if (msg instanceof HttpContent) {
            this.encodeHttpContent(ctx, (HttpContent)msg, out);
            return;
        }
        if (msg instanceof ByteBuf) {
            this.encodeByteBufContent(ctx, (ByteBuf)msg, out);
            return;
        }
        if (msg instanceof FileRegion) {
            void var3_5;
            void var1_1;
            this.encodeFileRegionContent((ChannelHandlerContext)var1_1, (FileRegion)msg, (List<Object>)var3_5);
            return;
        }
        try {
            HttpObjectEncoder.throwUnexpectedMessageTypeEx(msg, this.state);
        }
        catch (Throwable throwable) {
            void var2_4;
            ReferenceCountUtil.release((Object)var2_4);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)msg);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeFullHttpMessage(ChannelHandlerContext ctx, Object o, List<Object> out) throws Exception {
        assert (o instanceof FullHttpMessage);
        FullHttpMessage msg = (FullHttpMessage)o;
        try {
            void var3_4;
            void var1_1;
            void var2_3;
            HttpMessage m;
            if (this.state != 0) {
                HttpObjectEncoder.throwUnexpectedMessageTypeEx(o, this.state);
            }
            int state = this.isContentAlwaysEmpty(m = (HttpMessage)o) ? 3 : (HttpUtil.isTransferEncodingChunked(m) ? 2 : 1);
            ByteBuf content = msg.content();
            boolean accountForContentSize = content.readableBytes() > 0 && state == 1 && content.readableBytes() <= Math.max(128, (int)this.headersEncodedSizeAccumulator / 8);
            int headersAndContentSize = (int)this.headersEncodedSizeAccumulator + (accountForContentSize ? content.readableBytes() : 0);
            ByteBuf buf = ctx.alloc().buffer(headersAndContentSize);
            this.encodeInitialLine(buf, m);
            this.sanitizeHeadersBeforeEncode(m, state == 3);
            this.encodeHeaders(var2_3.headers(), buf);
            ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
            this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
            this.encodeByteBufHttpContent(state, (ChannelHandlerContext)var1_1, buf, content, msg.trailingHeaders(), (List<Object>)var3_4);
            return;
        }
        finally {
            msg.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean encodeContentNonChunk(List<Object> out, ByteBuf buf, ByteBuf content) {
        int contentLength = content.readableBytes();
        if (contentLength > 0) {
            void var3_3;
            if (buf.maxFastWritableBytes() >= var3_3) {
                buf.writeBytes(content);
                out.add(buf);
            } else {
                void var2_2;
                List<Object> list;
                void var1_1;
                out.add(var1_1);
                list.add(var2_2.retain());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void throwUnexpectedMessageTypeEx(Object msg, int state) {
        void var1_1;
        Object object;
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName((Object)object) + ", state: " + (int)var1_1);
    }

    /*
     * Unable to fully structure code
     */
    private void encodeFileRegionContent(ChannelHandlerContext ctx, FileRegion msg, List<Object> out) {
        try {
            if (!HttpObjectEncoder.$assertionsDisabled && this.state == 0) {
                throw new AssertionError();
            }
            switch (this.state) {
                case 1: {
                    if (msg.count() > 0L) {
                        out.add(msg.retain());
                        ** break;
                    }
                }
                case 3: {
                    out.add(Unpooled.EMPTY_BUFFER);
                    ** break;
                }
                case 2: {
                    HttpObjectEncoder.encodedChunkedFileRegionContent((ChannelHandlerContext)var1_1, msg, (List<Object>)var3_4);
                    ** break;
                }
                default: {
                    throw new Error();
lbl19:
                    // 3 sources

                    ** break;
                }
            }
        }
        catch (Throwable var1_2) {
            var2_3.release();
            throw var1_2;
        }
lbl24:
        // 1 sources

        msg.release();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean bypassEncoderIfEmpty(ByteBuf msg, List<Object> out) {
        if (!msg.isReadable()) {
            ByteBuf byteBuf;
            void var1_1;
            var1_1.add(byteBuf.retain());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void encodeByteBufContent(ChannelHandlerContext ctx, ByteBuf content, List<Object> out) {
        void var3_4;
        void var1_1;
        block4: {
            try {
                assert (this.state != 0);
                if (!HttpObjectEncoder.bypassEncoderIfEmpty(content, out)) break block4;
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.release();
                throw throwable;
            }
            content.release();
            return;
        }
        HttpObjectEncoder httpObjectEncoder = this;
        httpObjectEncoder.encodeByteBufAndTrailers(httpObjectEncoder.state, (ChannelHandlerContext)var1_1, (List<Object>)var3_4, content, null);
        content.release();
    }

    /*
     * WARNING - void declaration
     */
    private static int encodeEmptyLastHttpContent(int state, List<Object> out) {
        int n;
        assert (state != 0);
        switch (n) {
            case 1: 
            case 3: {
                out.add(Unpooled.EMPTY_BUFFER);
                break;
            }
            case 2: {
                void var1_1;
                var1_1.add(ZERO_CRLF_CRLF_BUF.duplicate());
                break;
            }
            default: {
                throw new Error();
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void encodeLastHttpContent(ChannelHandlerContext ctx, LastHttpContent msg, List<Object> out) {
        assert (this.state != 0);
        assert (!(msg instanceof HttpMessage));
        try {
            void var3_4;
            void var1_1;
            HttpObjectEncoder httpObjectEncoder = this;
            httpObjectEncoder.encodeByteBufAndTrailers(httpObjectEncoder.state, (ChannelHandlerContext)var1_1, (List<Object>)var3_4, msg.content(), msg.trailingHeaders());
            this.state = 0;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.release();
            throw throwable;
        }
        msg.release();
    }

    /*
     * WARNING - void declaration
     */
    private void encodeHttpContent(ChannelHandlerContext ctx, HttpContent msg, List<Object> out) {
        assert (this.state != 0);
        assert (!(msg instanceof HttpMessage));
        assert (!(msg instanceof LastHttpContent));
        try {
            void var3_4;
            void var1_1;
            HttpObjectEncoder httpObjectEncoder = this;
            httpObjectEncoder.encodeByteBufAndTrailers(httpObjectEncoder.state, (ChannelHandlerContext)var1_1, (List<Object>)var3_4, msg.content(), null);
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.release();
            throw throwable;
        }
        msg.release();
    }

    /*
     * WARNING - void declaration
     */
    private void encodeByteBufAndTrailers(int state, ChannelHandlerContext ctx, List<Object> out, ByteBuf content, HttpHeaders trailingHeaders) {
        switch (state) {
            case 1: {
                if (content.isReadable()) {
                    out.add(content.retain());
                    return;
                }
            }
            case 3: {
                out.add(Unpooled.EMPTY_BUFFER);
                return;
            }
            case 2: {
                void var3_3;
                void var2_2;
                this.encodeChunkedHttpContent((ChannelHandlerContext)var2_2, content, trailingHeaders, (List<Object>)var3_3);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    private void encodeChunkedHttpContent(ChannelHandlerContext ctx, ByteBuf content, HttpHeaders trailingHeaders, List<Object> out) {
        int contentLength = content.readableBytes();
        if (contentLength > 0) {
            HttpObjectEncoder.addEncodedLengthHex(ctx, contentLength, out);
            out.add(content.retain());
            out.add(CRLF_BUF.duplicate());
        }
        if (trailingHeaders != null) {
            void var3_3;
            void var1_1;
            this.encodeTrailingHeaders((ChannelHandlerContext)var1_1, (HttpHeaders)var3_3, out);
            return;
        }
        if (contentLength == 0) {
            void var2_2;
            out.add(var2_2.retain());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeTrailingHeaders(ChannelHandlerContext ctx, HttpHeaders trailingHeaders, List<Object> out) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (trailingHeaders.isEmpty()) {
            out.add(ZERO_CRLF_CRLF_BUF.duplicate());
            return;
        }
        ByteBuf buf = ctx.alloc().buffer((int)this.trailersEncodedSizeAccumulator);
        ByteBufUtil.writeMediumBE((ByteBuf)buf, (int)3149066);
        this.encodeHeaders((HttpHeaders)var2_2, buf);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
        this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
        var3_3.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf encodeInitHttpMessage(ChannelHandlerContext ctx, H m) throws Exception {
        void var1_1;
        void var2_2;
        assert (this.state == 0);
        ByteBuf buf = ctx.alloc().buffer((int)this.headersEncodedSizeAccumulator);
        this.encodeInitialLine(buf, m);
        this.state = this.isContentAlwaysEmpty(m) ? 3 : (HttpUtil.isTransferEncodingChunked(m) ? 2 : 1);
        this.sanitizeHeadersBeforeEncode(m, this.state == 3);
        this.encodeHeaders(var2_2.headers(), buf);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
        this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iter = headers.iteratorCharSequence();
        while (iter.hasNext()) {
            void var3_3;
            Map.Entry<CharSequence, CharSequence> header = iter.next();
            HttpHeadersEncoder.encoderHeader(header.getKey(), (CharSequence)var3_3.getValue(), buf);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void encodedChunkedFileRegionContent(ChannelHandlerContext ctx, FileRegion msg, List<Object> out) {
        void var3_3;
        long contentLength = msg.count();
        if (contentLength > 0L) {
            ChannelHandlerContext channelHandlerContext;
            HttpObjectEncoder.addEncodedLengthHex(channelHandlerContext, contentLength, out);
            out.add(msg.retain());
            out.add(CRLF_BUF.duplicate());
            return;
        }
        if (var3_3 == 0L) {
            void var1_1;
            void var2_2;
            var2_2.add(var1_1.retain());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addEncodedLengthHex(ChannelHandlerContext ctx, long contentLength, List<Object> out) {
        ChannelHandlerContext channelHandlerContext;
        void var3_3;
        void var1_2;
        String lengthHex = Long.toHexString(contentLength);
        ChannelHandlerContext buf = ctx.alloc().buffer(lengthHex.length() + 2);
        buf.writeCharSequence((CharSequence)var1_2, CharsetUtil.US_ASCII);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)3338);
        var3_3.add(channelHandlerContext);
    }

    protected void sanitizeHeadersBeforeEncode(H msg, boolean isAlwaysEmpty) {
    }

    protected boolean isContentAlwaysEmpty(H msg) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return msg == Unpooled.EMPTY_BUFFER || msg == LastHttpContent.EMPTY_LAST_CONTENT || msg instanceof FullHttpMessage || msg instanceof HttpMessage || msg instanceof LastHttpContent || msg instanceof HttpContent || msg instanceof ByteBuf || var1_1 instanceof FileRegion;
    }

    private static int padSizeForAccumulation(int readableBytes) {
        return (readableBytes << 2) / 3;
    }

    @Deprecated
    protected static void encodeAscii(String s, ByteBuf buf) {
        String string;
        buf.writeCharSequence((CharSequence)string, CharsetUtil.US_ASCII);
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

