/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_CHUNKED_SUPPORTED = true;
    public static final boolean DEFAULT_ALLOW_PARTIAL_CHUNKS = true;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final boolean DEFAULT_ALLOW_DUPLICATE_CONTENT_LENGTHS = false;
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private final boolean allowPartialChunks;
    @Deprecated
    protected final boolean validateHeaders;
    protected final HttpHeadersFactory headersFactory;
    protected final HttpHeadersFactory trailersFactory;
    private final boolean allowDuplicateContentLengths;
    private final ByteBuf parserScratchBuffer;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private boolean chunked;
    private boolean isSwitchingToNonHttp1Protocol;
    private final AtomicBoolean resetRequested = new AtomicBoolean();
    private AsciiString name;
    private String value;
    private LastHttpContent trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;
    private static final boolean[] SP_LENIENT_BYTES;
    private static final boolean[] LATIN_WHITESPACE;
    private static final boolean[] ISO_CONTROL_OR_WHITESPACE;
    private static final ByteProcessor SKIP_CONTROL_CHARS_BYTES;

    /*
     * WARNING - void declaration
     */
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            this.parserScratchBuffer.release();
        }
        catch (Throwable throwable) {
            void var1_1;
            super.handlerRemoved0((ChannelHandlerContext)var1_1);
            throw throwable;
        }
        super.handlerRemoved0(ctx);
    }

    protected HttpObjectDecoder() {
        this(new HttpDecoderConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setChunkedSupported(chunkedSupported));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported, boolean validateHeaders) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setChunkedSupported(chunkedSupported).setValidateHeaders(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported, boolean validateHeaders, int initialBufferSize) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setChunkedSupported(chunkedSupported).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setChunkedSupported(chunkedSupported).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected HttpObjectDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean chunkedSupported, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths, boolean allowPartialChunks) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setChunkedSupported(chunkedSupported).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths).setAllowPartialChunks(allowPartialChunks));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpObjectDecoder(HttpDecoderConfig config) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)config, (String)"config");
        this.parserScratchBuffer = Unpooled.buffer((int)config.getInitialBufferSize());
        HttpObjectDecoder httpObjectDecoder = this;
        this.lineParser = httpObjectDecoder.new LineParser(httpObjectDecoder.parserScratchBuffer, config.getMaxInitialLineLength());
        this.headerParser = new HeaderParser(this.parserScratchBuffer, config.getMaxHeaderSize());
        this.maxChunkSize = config.getMaxChunkSize();
        this.chunkedSupported = config.isChunkedSupported();
        this.headersFactory = config.getHeadersFactory();
        this.trailersFactory = config.getTrailersFactory();
        this.validateHeaders = this.isValidating(this.headersFactory);
        this.allowDuplicateContentLengths = config.isAllowDuplicateContentLengths();
        this.allowPartialChunks = var1_1.isAllowPartialChunks();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isValidating(HttpHeadersFactory headersFactory) {
        if (headersFactory instanceof DefaultHttpHeadersFactory) {
            void var1_1;
            DefaultHttpHeadersFactory builder = (DefaultHttpHeadersFactory)headersFactory;
            return builder.isValidatingHeaderNames() || var1_1.isValidatingHeaderValues();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                ByteBuf line;
                try {
                    line = this.lineParser.parse(buffer);
                    if (line == null) {
                        return;
                    }
                    String[] initialLine = this.splitInitialLine(line);
                    assert (initialLine.length == 3) : "initialLine::length must be 3";
                    this.message = this.createMessage(initialLine);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception e) {
                    HttpObjectDecoder httpObjectDecoder = this;
                    out.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, buffer, e));
                    return;
                }
            }
            case READ_HEADER: {
                try {
                    State nextState = this.readHeaders(buffer);
                    if (nextState == null) {
                        return;
                    }
                    this.currentState = nextState;
                    switch (nextState) {
                        case SKIP_CONTROL_CHARS: {
                            this.addCurrentMessage(out);
                            out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case READ_CHUNK_SIZE: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            this.addCurrentMessage(out);
                            return;
                        }
                    }
                    if (this.contentLength == 0L || this.contentLength == -1L && this.isDecodingRequest()) {
                        this.addCurrentMessage(out);
                        out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (nextState == State.READ_FIXED_LENGTH_CONTENT || nextState == State.READ_VARIABLE_LENGTH_CONTENT);
                    this.addCurrentMessage(out);
                    if (nextState == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = this.contentLength;
                    }
                    return;
                }
                catch (Exception e) {
                    HttpObjectDecoder httpObjectDecoder = this;
                    out.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, buffer, e));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = Math.min(buffer.readableBytes(), this.maxChunkSize);
                if (toRead > 0) {
                    ByteBuf content = buffer.readRetainedSlice(toRead);
                    out.add(new DefaultHttpContent(content));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int readLimit = buffer.readableBytes();
                if (readLimit == 0) {
                    return;
                }
                int toRead = Math.min(readLimit, this.maxChunkSize);
                if ((long)toRead > this.chunkSize) {
                    toRead = (int)this.chunkSize;
                }
                ByteBuf content = buffer.readRetainedSlice(toRead);
                this.chunkSize -= (long)toRead;
                if (this.chunkSize == 0L) {
                    out.add(new DefaultLastHttpContent(content, this.trailersFactory));
                    this.resetNow();
                    return;
                }
                out.add(new DefaultHttpContent(content));
                return;
            }
            case READ_CHUNK_SIZE: {
                ByteBuf line;
                try {
                    line = this.lineParser.parse(buffer);
                    if (line == null) {
                        return;
                    }
                    int chunkSize = HttpObjectDecoder.getChunkSize(line.array(), line.arrayOffset() + line.readerIndex(), line.readableBytes());
                    this.chunkSize = chunkSize;
                    if (chunkSize == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception e) {
                    out.add(this.invalidChunk(buffer, e));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int toRead = Math.min((int)this.chunkSize, this.maxChunkSize);
                if (!this.allowPartialChunks && buffer.readableBytes() < toRead) {
                    return;
                }
                if ((toRead = Math.min(toRead, buffer.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent chunk = new DefaultHttpContent(buffer.readRetainedSlice(toRead));
                this.chunkSize -= (long)toRead;
                out.add(chunk);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int wIdx = buffer.writerIndex();
                int rIdx = buffer.readerIndex();
                while (wIdx > rIdx) {
                    byte by;
                    if ((by = buffer.getByte(rIdx++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                buffer.readerIndex(rIdx);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent trailer = this.readTrailingHeaders(buffer);
                    if (trailer == null) {
                        return;
                    }
                    out.add(trailer);
                    this.resetNow();
                    return;
                }
                catch (Exception e) {
                    out.add(this.invalidChunk(buffer, e));
                    return;
                }
            }
            case BAD_MESSAGE: {
                ByteBuf byteBuf = buffer;
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            case UPGRADED: {
                void var1_10;
                void var2_11;
                void var3_12;
                int readableBytes = buffer.readableBytes();
                if (readableBytes <= 0) break;
                var3_12.add(var2_11.readBytes((int)var1_10));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var1_1;
        super.decodeLast((ChannelHandlerContext)var1_1, in, out);
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case READ_VARIABLE_LENGTH_CONTENT: {
                void var2_3;
                if (!this.chunked && !var2_3.isReadable()) {
                    out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                    this.resetNow();
                }
                return;
            }
            case READ_HEADER: {
                HttpObjectDecoder httpObjectDecoder = this;
                out.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, Unpooled.EMPTY_BUFFER, (Exception)new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            case READ_CHUNK_SIZE: 
            case READ_FIXED_LENGTH_CONTENT: 
            case READ_CHUNKED_CONTENT: 
            case READ_CHUNK_DELIMITER: 
            case READ_CHUNK_FOOTER: {
                boolean bl;
                if (!(this.isDecodingRequest() || this.chunked ? true : (bl = this.contentLength > 0L))) {
                    void var3_4;
                    var3_4.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
                this.resetNow();
                return;
            }
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: 
            case BAD_MESSAGE: 
            case UPGRADED: {
                return;
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.currentState));
    }

    /*
     * WARNING - void declaration
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        if (evt instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                }
            }
        }
        super.userEventTriggered((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void addCurrentMessage(List<Object> out) {
        void var2_2;
        void var1_1;
        HttpMessage message = this.message;
        assert (message != null);
        this.message = null;
        var1_1.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            void var3_3;
            HttpStatusClass httpStatusClass;
            HttpResponse res = (HttpResponse)msg;
            HttpResponseStatus status = res.status();
            int code = status.code();
            if ((httpStatusClass = ((HttpResponseStatus)((Object)httpStatusClass)).codeClass()) == HttpStatusClass.INFORMATIONAL) {
                void var1_1;
                return code != 101 || res.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !var1_1.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
            }
            switch (var3_3) {
                case 204: 
                case 304: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse msg) {
        void var1_1;
        if (msg.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String newProtocol = msg.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
        return newProtocol == null || !newProtocol.contains(HttpVersion.HTTP_1_0.text()) && !var1_1.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested.lazySet(true);
    }

    private void resetNow() {
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.chunked = false;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (this.isSwitchingToNonHttp1Protocol) {
            this.isSwitchingToNonHttp1Protocol = false;
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested.lazySet(false);
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    /*
     * WARNING - void declaration
     */
    private HttpMessage invalidMessage(HttpMessage current, ByteBuf in, Exception cause) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        void v0 = var2_2;
        v0.skipBytes(v0.readableBytes());
        if (current == null) {
            current = this.createInvalidMessage();
        }
        current.setDecoderResult(DecoderResult.failure((Throwable)var3_3));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent invalidChunk(ByteBuf in, Exception cause) {
        void var1_1;
        void var2_2;
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        ByteBuf byteBuf = in;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent chunk = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        chunk.setDecoderResult(DecoderResult.failure((Throwable)var2_2));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private State readHeaders(ByteBuf buffer) {
        HttpMessage message = this.message;
        HttpHeaders headers = message.headers();
        HeaderParser headerParser = this.headerParser;
        ByteBuf line = headerParser.parse(buffer);
        if (line == null) {
            return null;
        }
        int lineLength = line.readableBytes();
        while (lineLength > 0) {
            int trimmedLine2;
            String valueStr;
            byte[] lineContent = line.array();
            int startLine22 = line.arrayOffset() + line.readerIndex();
            byte firstChar = lineContent[startLine22];
            if (this.name != null && (firstChar == 32 || firstChar == 9)) {
                String trimmedLine2 = HttpObjectDecoder.langAsciiString(lineContent, startLine22, lineLength).trim();
                valueStr = this.value;
                this.value = valueStr + ' ' + trimmedLine2;
            } else {
                if (this.name != null) {
                    headers.add((CharSequence)this.name, (Object)this.value);
                }
                this.splitHeader((byte[])valueStr, startLine22, trimmedLine2);
            }
            ByteBuf startLine22 = headerParser.parse(buffer);
            if (startLine22 == null) {
                return null;
            }
            trimmedLine2 = startLine22.readableBytes();
        }
        if (this.name != null) {
            headers.add((CharSequence)this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        HttpMessageDecoderResult decoderResult = new HttpMessageDecoderResult(this.lineParser.size, headerParser.size);
        message.setDecoderResult(decoderResult);
        List<String> contentLengthFields = headers.getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (!contentLengthFields.isEmpty()) {
            HttpVersion version = message.protocolVersion();
            boolean isHttp10OrEarlier = version.majorVersion() <= 0 || version.majorVersion() == 1 && version.minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength(contentLengthFields, isHttp10OrEarlier, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                String lengthValue = contentLengthFields.get(0).trim();
                if (contentLengthFields.size() > 1 || !lengthValue.equals(Long.toString(this.contentLength))) {
                    void var3_3;
                    var3_3.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.contentLength);
                }
            }
        } else {
            this.contentLength = HttpUtil.getWebSocketContentLength(message);
        }
        if (!this.isDecodingRequest() && message instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)message;
            this.isSwitchingToNonHttp1Protocol = this.isSwitchingToNonHttp1Protocol(res);
        }
        if (this.isContentAlwaysEmpty(message)) {
            HttpUtil.setTransferEncodingChunked(message, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(message)) {
            this.chunked = true;
            if (!contentLengthFields.isEmpty() && message.protocolVersion() == HttpVersion.HTTP_1_1) {
                void var2_2;
                this.handleTransferEncodingChunkedWithContentLength((HttpMessage)var2_2);
            }
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage message) {
        message.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private LastHttpContent readTrailingHeaders(ByteBuf buffer) {
        HeaderParser headerParser = this.headerParser;
        ByteBuf line = headerParser.parse(buffer);
        if (line == null) {
            return null;
        }
        LastHttpContent trailer = this.trailer;
        int lineLength = line.readableBytes();
        if (lineLength == 0 && trailer == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        AsciiString lastHeader = null;
        if (trailer == null) {
            trailer = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.trailersFactory);
        }
        while (lineLength > 0) {
            ByteBuf byteBuf;
            byte[] lineContent = line.array();
            int startLine = line.arrayOffset() + line.readerIndex();
            byte firstChar = lineContent[startLine];
            if (lastHeader != null && (firstChar == 32 || firstChar == 9)) {
                List<String> current = trailer.trailingHeaders().getAll((CharSequence)lastHeader);
                if (!current.isEmpty()) {
                    int lastPos = current.size() - 1;
                    String lineTrimmed = HttpObjectDecoder.langAsciiString(lineContent, startLine, line.readableBytes()).trim();
                    String currentLastPos = current.get(lastPos);
                    current.set(lastPos, currentLastPos + (String)byteBuf);
                }
            } else {
                void current;
                void var7_8;
                this.splitHeader((byte[])var7_8, startLine, (int)current);
                AsciiString headerName = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)headerName) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)headerName) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)headerName))) {
                    trailer.trailingHeaders().add((CharSequence)headerName, (Object)this.value);
                }
                lastHeader = this.name;
                this.name = null;
                this.value = null;
            }
            byteBuf = headerParser.parse(buffer);
            if (byteBuf == null) {
                return null;
            }
            int n = byteBuf.readableBytes();
        }
        this.trailer = null;
        return trailer;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1) throws Exception;

    protected abstract HttpMessage createInvalidMessage();

    /*
     * WARNING - void declaration
     */
    private static int skipWhiteSpaces(byte[] hex, int start, int length) {
        void var2_2;
        for (int i = 0; i < length; ++i) {
            if (HttpObjectDecoder.isWhitespace(hex[start + i])) continue;
            return i;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int getChunkSize(byte[] hex, int start, int length) {
        void var3_4;
        int skipped = HttpObjectDecoder.skipWhiteSpaces(hex, start, length);
        if (skipped == length) {
            throw new NumberFormatException();
        }
        start += skipped;
        length -= skipped;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int digit = StringUtil.decodeHexNibble((byte)hex[start + i]);
            if (digit == -1) {
                void var0_1;
                byte b = hex[start + i];
                if (b == 59 || HttpObjectDecoder.isControlOrWhitespaceAsciiChar((byte)var0_1)) {
                    if (i == 0) {
                        throw new NumberFormatException("Empty chunk size");
                    }
                    return result;
                }
                throw new NumberFormatException("Invalid character in chunk size");
            }
            result <<= 4;
            if ((result += digit) >= 0) continue;
            throw new NumberFormatException("Chunk size overflow: " + result);
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private String[] splitInitialLine(ByteBuf asciiBuffer) {
        void var1_2;
        void var2_3;
        int n;
        int startContent;
        int end;
        byte[] asciiBytes = asciiBuffer.array();
        byte lastByte = asciiBytes[(end = (startContent = (n = asciiBuffer.arrayOffset()) + asciiBuffer.readerIndex()) + asciiBuffer.readableBytes()) - 1];
        if (HttpObjectDecoder.isControlOrWhitespaceAsciiChar(lastByte) && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS(lastByte))) {
            throw new IllegalArgumentException("Illegal character in request line: 0x" + Integer.toHexString(lastByte));
        }
        int aStart = HttpObjectDecoder.findNonSPLenient(asciiBytes, startContent, end);
        int aEnd = HttpObjectDecoder.findSPLenient(asciiBytes, aStart, end);
        int bStart = HttpObjectDecoder.findNonSPLenient(asciiBytes, aEnd, end);
        int bEnd = HttpObjectDecoder.findSPLenient(asciiBytes, bStart, end);
        int cStart = HttpObjectDecoder.findNonSPLenient(asciiBytes, bEnd, end);
        int cEnd = HttpObjectDecoder.findEndOfString(asciiBytes, Math.max(cStart - 1, n), end);
        return new String[]{this.splitFirstWordInitialLine(asciiBytes, aStart, aEnd - aStart), this.splitSecondWordInitialLine(asciiBytes, bStart, bEnd - bStart), cStart < cEnd ? this.splitThirdWordInitialLine((byte[])var2_3, cStart, (int)(var1_2 - cStart)) : ""};
    }

    /*
     * WARNING - void declaration
     */
    protected String splitFirstWordInitialLine(byte[] asciiContent, int start, int length) {
        void var3_3;
        void var2_2;
        return HttpObjectDecoder.langAsciiString(asciiContent, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected String splitSecondWordInitialLine(byte[] asciiContent, int start, int length) {
        void var3_3;
        void var2_2;
        return HttpObjectDecoder.langAsciiString(asciiContent, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected String splitThirdWordInitialLine(byte[] asciiContent, int start, int length) {
        void var3_3;
        void var2_2;
        return HttpObjectDecoder.langAsciiString(asciiContent, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static String langAsciiString(byte[] asciiContent, int start, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (length == 0) {
            return "";
        }
        if (start == 0) {
            if (length == asciiContent.length) {
                return new String(asciiContent, 0, 0, asciiContent.length);
            }
            return new String(asciiContent, 0, 0, length);
        }
        return new String(byArray, 0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void splitHeader(byte[] line, int start, int length) {
        void var2_2;
        void var1_1;
        void var3_3;
        int colonEnd;
        byte ch;
        int nameEnd;
        int end = start + length;
        int nameStart = start;
        boolean isDecodingRequest = this.isDecodingRequest();
        for (nameEnd = nameStart; nameEnd < end && (ch = line[nameEnd]) != 58 && (isDecodingRequest || !HttpObjectDecoder.isOWS(ch)); ++nameEnd) {
        }
        if (nameEnd == end) {
            throw new IllegalArgumentException("No colon found");
        }
        for (colonEnd = nameEnd; colonEnd < end; ++colonEnd) {
            if (line[colonEnd] != 58) continue;
            ++colonEnd;
            break;
        }
        this.name = this.splitHeaderName(line, nameStart, nameEnd - nameStart);
        int valueStart = HttpObjectDecoder.findNonWhitespace(line, colonEnd, end);
        if (valueStart == end) {
            this.value = "";
            return;
        }
        int valueEnd = HttpObjectDecoder.findEndOfString(line, start, (int)var3_3);
        this.value = HttpObjectDecoder.langAsciiString((byte[])var1_1, valueStart, (int)(var2_2 - valueStart));
    }

    /*
     * WARNING - void declaration
     */
    protected AsciiString splitHeaderName(byte[] sb, int start, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new AsciiString((byte[])var1_1, (int)var2_2, (int)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    private static int findNonSPLenient(byte[] sb, int offset, int end) {
        void var2_2;
        for (int result = offset; result < end; ++result) {
            void var3_3;
            byte c = sb[result];
            if (HttpObjectDecoder.isSPLenient(c)) continue;
            if (HttpObjectDecoder.isWhitespace((byte)var3_3)) {
                throw new IllegalArgumentException("Invalid separator");
            }
            return result;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int findSPLenient(byte[] sb, int offset, int end) {
        void var2_2;
        for (int result = offset; result < end; ++result) {
            if (!HttpObjectDecoder.isSPLenient(sb[result])) continue;
            return result;
        }
        return (int)var2_2;
    }

    private static boolean isSPLenient(byte c) {
        byte by;
        return SP_LENIENT_BYTES[by + 128];
    }

    private static boolean isWhitespace(byte b) {
        byte by;
        return LATIN_WHITESPACE[by + 128];
    }

    /*
     * WARNING - void declaration
     */
    private static int findNonWhitespace(byte[] sb, int offset, int end) {
        void var2_2;
        for (int result = offset; result < end; ++result) {
            void var3_3;
            byte c = sb[result];
            if (!HttpObjectDecoder.isWhitespace(c)) {
                return result;
            }
            if (HttpObjectDecoder.isOWS(c)) continue;
            throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + c + "' (0x" + Integer.toHexString((int)var3_3) + ")");
        }
        return (int)var2_2;
    }

    private static int findEndOfString(byte[] sb, int start, int end) {
        for (int result = end - 1; result > start; --result) {
            if (HttpObjectDecoder.isOWS(sb[result])) continue;
            return result + 1;
        }
        return 0;
    }

    private static boolean isOWS(byte ch) {
        byte by;
        return ch == 32 || by == 9;
    }

    private static boolean isControlOrWhitespaceAsciiChar(byte b) {
        byte by;
        return ISO_CONTROL_OR_WHITESPACE[by + 128];
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$002(HttpObjectDecoder x0, State x1) {
        void var1_1;
        x0.currentState = var1_1;
        return x0.currentState;
    }

    static {
        byte b;
        boolean[] blArray = new boolean[256];
        SP_LENIENT_BYTES = blArray;
        blArray[160] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[137] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[139] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[140] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[141] = true;
        LATIN_WHITESPACE = new boolean[256];
        for (b = -128; b < 127; b = (byte)((byte)(b + 1))) {
            HttpObjectDecoder.LATIN_WHITESPACE[b + 128] = Character.isWhitespace(b);
        }
        ISO_CONTROL_OR_WHITESPACE = new boolean[256];
        for (b = -128; b < 127; b = (byte)(b + 1)) {
            HttpObjectDecoder.ISO_CONTROL_OR_WHITESPACE[b + 128] = Character.isISOControl(b) || HttpObjectDecoder.isWhitespace(b);
        }
        SKIP_CONTROL_CHARS_BYTES = new ByteProcessor(){

            /*
             * WARNING - void declaration
             */
            public final boolean process(byte value) {
                void var1_1;
                return ISO_CONTROL_OR_WHITESPACE[var1_1 + 128];
            }
        };
    }

    private final class LineParser
    extends HeaderParser {
        /*
         * WARNING - void declaration
         */
        LineParser(ByteBuf seq, int maxLength) {
            void var3_3;
            void var2_2;
            super((ByteBuf)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf parse(ByteBuf buffer) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.reset();
            int readableBytes = buffer.readableBytes();
            if (readableBytes == 0) {
                return null;
            }
            int readerIndex = buffer.readerIndex();
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS && this.skipControlChars(buffer, (int)var2_2, (int)var3_3)) {
                return null;
            }
            return super.parse((ByteBuf)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean skipControlChars(ByteBuf buffer, int readableBytes, int readerIndex) {
            void var3_3;
            void var1_1;
            assert (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS);
            int maxToSkip = Math.min(this.maxLength, readableBytes);
            int firstNonControlIndex = buffer.forEachByte(readerIndex, maxToSkip, SKIP_CONTROL_CHARS_BYTES);
            if (firstNonControlIndex == -1) {
                void var2_2;
                buffer.skipBytes(maxToSkip);
                if (var2_2 > this.maxLength) {
                    LineParser lineParser = this;
                    throw lineParser.newException(lineParser.maxLength);
                }
                return true;
            }
            var1_1.readerIndex((int)var3_3);
            HttpObjectDecoder.access$002(HttpObjectDecoder.this, State.READ_INITIAL);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final TooLongFrameException newException(int maxLength) {
            void var1_1;
            return new TooLongHttpLineException("An HTTP line is larger than " + (int)var1_1 + " bytes.");
        }
    }

    private static class HeaderParser {
        protected final ByteBuf seq;
        protected final int maxLength;
        int size;

        /*
         * WARNING - void declaration
         */
        HeaderParser(ByteBuf seq, int maxLength) {
            void var2_2;
            void var1_1;
            this.seq = var1_1;
            this.maxLength = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public ByteBuf parse(ByteBuf buffer) {
            void var1_1;
            void var2_2;
            void var3_3;
            int readableBytes = buffer.readableBytes();
            int readerIndex = buffer.readerIndex();
            int maxBodySize = this.maxLength - this.size;
            assert (maxBodySize >= 0);
            long l = (long)maxBodySize + 2L;
            int toProcess = (int)Math.min(l, (long)readableBytes);
            int toIndexExclusive = readerIndex + toProcess;
            assert (toIndexExclusive >= readerIndex);
            int indexOfLf = buffer.indexOf(readerIndex, toIndexExclusive, (byte)10);
            if (indexOfLf == -1) {
                if (readableBytes > maxBodySize) {
                    HeaderParser headerParser = this;
                    throw headerParser.newException(headerParser.maxLength);
                }
                return null;
            }
            int endOfSeqIncluded = indexOfLf > readerIndex && buffer.getByte(indexOfLf - 1) == 13 ? indexOfLf - 1 : indexOfLf;
            int newSize = endOfSeqIncluded - readerIndex;
            if (newSize == 0) {
                this.seq.clear();
                buffer.readerIndex(indexOfLf + 1);
                return this.seq;
            }
            int size = this.size + newSize;
            if (size > this.maxLength) {
                HeaderParser headerParser = this;
                throw headerParser.newException(headerParser.maxLength);
            }
            this.size = size;
            this.seq.clear();
            this.seq.writeBytes(buffer, (int)var3_3, (int)var2_2);
            var1_1.readerIndex(indexOfLf + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        /*
         * WARNING - void declaration
         */
        protected TooLongFrameException newException(int maxLength) {
            void var1_1;
            return new TooLongHttpHeaderException("HTTP header is larger than " + (int)var1_1 + " bytes.");
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

