/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageAggregator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpContentException;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class HttpObjectAggregator
extends MessageAggregator<HttpObject, HttpMessage, HttpContent, FullHttpMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final boolean closeOnExpectationFailed;

    /*
     * WARNING - void declaration
     */
    public HttpObjectAggregator(int maxContentLength) {
        this((int)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpObjectAggregator(int maxContentLength, boolean closeOnExpectationFailed) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.closeOnExpectationFailed = var2_2;
    }

    protected boolean isStartMessage(HttpObject msg) throws Exception {
        return msg instanceof HttpMessage;
    }

    protected boolean isContentMessage(HttpObject msg) throws Exception {
        return msg instanceof HttpContent;
    }

    protected boolean isLastContentMessage(HttpContent msg) throws Exception {
        return msg instanceof LastHttpContent;
    }

    protected boolean isAggregated(HttpObject msg) throws Exception {
        return msg instanceof FullHttpMessage;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isContentLengthInvalid(HttpMessage start, int maxContentLength) {
        try {
            void var2_2;
            return HttpUtil.getContentLength(start, -1L) > (long)var2_2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object continueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
        if (HttpUtil.isUnsupportedExpectation(start)) {
            pipeline.fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
            return EXPECTATION_FAILED.retainedDuplicate();
        }
        if (HttpUtil.is100ContinueExpected(start)) {
            void var2_2;
            void var1_1;
            HttpMessage httpMessage;
            if (HttpUtil.getContentLength(httpMessage, -1L) <= (long)var1_1) {
                return CONTINUE.retainedDuplicate();
            }
            var2_2.fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
            return TOO_LARGE.retainedDuplicate();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Object newContinueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
        void var2_3;
        void var3_4;
        Object response = HttpObjectAggregator.continueResponse(start, maxContentLength, (ChannelPipeline)var3_4);
        if (response != null) {
            void var1_1;
            var1_1.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean closeAfterContinueResponse(Object msg) {
        void var1_1;
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(var1_1);
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse httpResponse;
            httpResponse = httpResponse;
            return httpResponse.status().codeClass().equals((Object)HttpStatusClass.CLIENT_ERROR);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected FullHttpMessage beginAggregation(HttpMessage start, ByteBuf content) throws Exception {
        void var1_1;
        AggregatedFullHttpMessage ret;
        assert (!(start instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(start, false);
        if (start instanceof HttpRequest) {
            ret = new AggregatedFullHttpRequest((HttpRequest)start, content, null);
        } else if (ret instanceof HttpResponse) {
            void var2_2;
            ret = new AggregatedFullHttpResponse((HttpResponse)((Object)ret), (ByteBuf)var2_2, null);
        } else {
            throw new Error();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void aggregate(FullHttpMessage aggregated, HttpContent content) throws Exception {
        if (content instanceof LastHttpContent) {
            void var2_2;
            void var1_1;
            ((AggregatedFullHttpMessage)var1_1).setTrailingHeaders(((LastHttpContent)var2_2).trailingHeaders());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
        if (!HttpUtil.isContentLengthSet(aggregated)) {
            void var1_1;
            aggregated.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(var1_1.content().readableBytes()));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleOversizedMessage(ChannelHandlerContext ctx, HttpMessage oversized) throws Exception {
        if (oversized instanceof HttpRequest) {
            if (oversized instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected(oversized) && !HttpUtil.isKeepAlive(oversized)) {
                oversized = ctx.writeAndFlush((Object)TOO_LARGE_CLOSE.retainedDuplicate());
                oversized.addListener((GenericFutureListener)new ChannelFutureListener(this, ctx){
                    final /* synthetic */ ChannelHandlerContext val$ctx;
                    final /* synthetic */ HttpObjectAggregator this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$ctx = channelHandlerContext;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            void var1_1;
                            logger.debug("Failed to send a 413 Request Entity Too Large.", var1_1.cause());
                        }
                        this.val$ctx.close();
                    }
                });
                return;
            }
            ctx.writeAndFlush((Object)TOO_LARGE.retainedDuplicate()).addListener((GenericFutureListener)new ChannelFutureListener(this, ctx){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ HttpObjectAggregator this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        void var1_1;
                        logger.debug("Failed to send a 413 Request Entity Too Large.", var1_1.cause());
                        this.val$ctx.close();
                    }
                }
            });
            return;
        }
        if (oversized instanceof HttpResponse) {
            void var2_2;
            void var1_1;
            var1_1.close();
            throw new TooLongHttpContentException("Response entity too large: " + var2_2);
        }
        throw new IllegalStateException();
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        /*
         * WARNING - void declaration
         */
        AggregatedFullHttpResponse(HttpResponse message, ByteBuf content, HttpHeaders trailingHeaders) {
            super((HttpMessage)var1_1, (ByteBuf)var2_2, (HttpHeaders)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final FullHttpResponse copy() {
            AggregatedFullHttpResponse aggregatedFullHttpResponse = this;
            return aggregatedFullHttpResponse.replace(aggregatedFullHttpResponse.content().copy());
        }

        @Override
        public final FullHttpResponse duplicate() {
            AggregatedFullHttpResponse aggregatedFullHttpResponse = this;
            return aggregatedFullHttpResponse.replace(aggregatedFullHttpResponse.content().duplicate());
        }

        @Override
        public final FullHttpResponse retainedDuplicate() {
            AggregatedFullHttpResponse aggregatedFullHttpResponse = this;
            return aggregatedFullHttpResponse.replace(aggregatedFullHttpResponse.content().retainedDuplicate());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpResponse replace(ByteBuf content) {
            void var1_1;
            DefaultFullHttpResponse dup = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), content, this.headers().copy(), this.trailingHeaders().copy());
            dup.setDecoderResult(this.decoderResult());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpResponse setStatus(HttpResponseStatus status) {
            void var1_1;
            ((HttpResponse)this.message).setStatus((HttpResponseStatus)var1_1);
            return this;
        }

        @Override
        public final HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).status();
        }

        @Override
        public final HttpResponseStatus status() {
            return this.getStatus();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpResponse setProtocolVersion(HttpVersion version) {
            void var1_1;
            super.setProtocolVersion((HttpVersion)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpResponse retain(int increment) {
            void var1_1;
            super.retain((int)var1_1);
            return this;
        }

        @Override
        public final FullHttpResponse retain() {
            super.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpResponse touch(Object hint) {
            void var1_1;
            super.touch(var1_1);
            return this;
        }

        @Override
        public final FullHttpResponse touch() {
            super.touch();
            return this;
        }

        public final String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        /*
         * WARNING - void declaration
         */
        AggregatedFullHttpRequest(HttpRequest request, ByteBuf content, HttpHeaders trailingHeaders) {
            super((HttpMessage)var1_1, (ByteBuf)var2_2, (HttpHeaders)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final FullHttpRequest copy() {
            AggregatedFullHttpRequest aggregatedFullHttpRequest = this;
            return aggregatedFullHttpRequest.replace(aggregatedFullHttpRequest.content().copy());
        }

        @Override
        public final FullHttpRequest duplicate() {
            AggregatedFullHttpRequest aggregatedFullHttpRequest = this;
            return aggregatedFullHttpRequest.replace(aggregatedFullHttpRequest.content().duplicate());
        }

        @Override
        public final FullHttpRequest retainedDuplicate() {
            AggregatedFullHttpRequest aggregatedFullHttpRequest = this;
            return aggregatedFullHttpRequest.replace(aggregatedFullHttpRequest.content().retainedDuplicate());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest replace(ByteBuf content) {
            void var1_1;
            DefaultFullHttpRequest dup = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), content, this.headers().copy(), this.trailingHeaders().copy());
            dup.setDecoderResult(this.decoderResult());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest retain(int increment) {
            void var1_1;
            super.retain((int)var1_1);
            return this;
        }

        @Override
        public final FullHttpRequest retain() {
            super.retain();
            return this;
        }

        @Override
        public final FullHttpRequest touch() {
            super.touch();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest touch(Object hint) {
            void var1_1;
            super.touch(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setMethod(HttpMethod method) {
            void var1_1;
            ((HttpRequest)this.message).setMethod((HttpMethod)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setUri(String uri) {
            void var1_1;
            ((HttpRequest)this.message).setUri((String)var1_1);
            return this;
        }

        @Override
        public final HttpMethod getMethod() {
            return ((HttpRequest)this.message).method();
        }

        @Override
        public final String getUri() {
            return ((HttpRequest)this.message).uri();
        }

        @Override
        public final HttpMethod method() {
            return this.getMethod();
        }

        @Override
        public final String uri() {
            return this.getUri();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setProtocolVersion(HttpVersion version) {
            void var1_1;
            super.setProtocolVersion((HttpVersion)var1_1);
            return this;
        }

        public final String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage
    implements FullHttpMessage {
        protected final HttpMessage message;
        private final ByteBuf content;
        private HttpHeaders trailingHeaders;

        /*
         * WARNING - void declaration
         */
        AggregatedFullHttpMessage(HttpMessage message, ByteBuf content, HttpHeaders trailingHeaders) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.message = var1_1;
            this.content = var2_2;
            this.trailingHeaders = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpHeaders trailingHeaders() {
            void var1_1;
            HttpHeaders trailingHeaders = this.trailingHeaders;
            if (trailingHeaders == null) {
                return EmptyHttpHeaders.INSTANCE;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void setTrailingHeaders(HttpHeaders trailingHeaders) {
            void var1_1;
            this.trailingHeaders = var1_1;
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.message.protocolVersion();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FullHttpMessage setProtocolVersion(HttpVersion version) {
            void var1_1;
            this.message.setProtocolVersion((HttpVersion)var1_1);
            return this;
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        public DecoderResult decoderResult() {
            return this.message.decoderResult();
        }

        @Override
        public DecoderResult getDecoderResult() {
            return this.message.decoderResult();
        }

        /*
         * WARNING - void declaration
         */
        public void setDecoderResult(DecoderResult result) {
            void var1_1;
            this.message.setDecoderResult((DecoderResult)var1_1);
        }

        public ByteBuf content() {
            return this.content;
        }

        public int refCnt() {
            return this.content.refCnt();
        }

        @Override
        public FullHttpMessage retain() {
            this.content.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FullHttpMessage retain(int increment) {
            void var1_1;
            this.content.retain((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FullHttpMessage touch(Object hint) {
            void var1_1;
            this.content.touch((Object)var1_1);
            return this;
        }

        @Override
        public FullHttpMessage touch() {
            this.content.touch();
            return this;
        }

        public boolean release() {
            return this.content.release();
        }

        /*
         * WARNING - void declaration
         */
        public boolean release(int decrement) {
            void var1_1;
            return this.content.release((int)var1_1);
        }

        @Override
        public abstract FullHttpMessage copy();

        @Override
        public abstract FullHttpMessage duplicate();

        @Override
        public abstract FullHttpMessage retainedDuplicate();
    }
}

