/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;

public class HttpMethod
implements Comparable<HttpMethod> {
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    public static final HttpMethod CONNECT = new HttpMethod("CONNECT");
    private static final EnumNameMap<HttpMethod> methodMap = new EnumNameMap(new EnumNameMap.Node<HttpMethod>(OPTIONS.toString(), OPTIONS), new EnumNameMap.Node<HttpMethod>(GET.toString(), GET), new EnumNameMap.Node<HttpMethod>(HEAD.toString(), HEAD), new EnumNameMap.Node<HttpMethod>(POST.toString(), POST), new EnumNameMap.Node<HttpMethod>(PUT.toString(), PUT), new EnumNameMap.Node<HttpMethod>(PATCH.toString(), PATCH), new EnumNameMap.Node<HttpMethod>(DELETE.toString(), DELETE), new EnumNameMap.Node<HttpMethod>(TRACE.toString(), TRACE), new EnumNameMap.Node<HttpMethod>(CONNECT.toString(), CONNECT));
    private final AsciiString name;

    /*
     * WARNING - void declaration
     */
    public static HttpMethod valueOf(String name) {
        String string;
        if (name == GET.name()) {
            return GET;
        }
        if (name == POST.name()) {
            return POST;
        }
        HttpMethod result = methodMap.get(name);
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        return new HttpMethod(string);
    }

    /*
     * WARNING - void declaration
     */
    public HttpMethod(String name) {
        void var1_1;
        name = ObjectUtil.checkNonEmptyAfterTrim((String)name, (String)"name");
        int index = HttpUtil.validateToken(name);
        if (index != -1) {
            void var2_2;
            throw new IllegalArgumentException("Illegal character in HTTP Method: 0x" + Integer.toHexString(name.charAt((int)var2_2)));
        }
        this.name = AsciiString.cached((String)var1_1);
    }

    public String name() {
        return this.name.toString();
    }

    public AsciiString asciiName() {
        return this.name;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpMethod)) {
            return false;
        }
        HttpMethod that = (HttpMethod)o;
        return this.name().equals(var1_1.name());
    }

    public String toString() {
        return this.name.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(HttpMethod o) {
        void var1_1;
        if (o == this) {
            return 0;
        }
        return this.name().compareTo(var1_1.name());
    }

    private static final class EnumNameMap<T> {
        private final Node<T>[] values;
        private final int valuesMask;

        /*
         * WARNING - void declaration
         */
        EnumNameMap(Node<T> ... nodes) {
            void var1_1;
            this.values = new Node[MathUtil.findNextPositivePowerOfTwo((int)nodes.length)];
            this.valuesMask = this.values.length - 1;
            for (void node : var1_1) {
                int i = EnumNameMap.hashCode(node.key) & this.valuesMask;
                if (this.values[i] != null) {
                    throw new IllegalArgumentException("index " + i + " collision between values: [" + this.values[i].key + ", " + node.key + ']');
                }
                this.values[i] = node;
            }
        }

        /*
         * WARNING - void declaration
         */
        final T get(String name) {
            void var2_2;
            void var1_1;
            Node<T> node = this.values[EnumNameMap.hashCode(name) & this.valuesMask];
            if (node == null || !node.key.equals(var1_1)) {
                return null;
            }
            return var2_2.value;
        }

        private static int hashCode(String name) {
            return name.hashCode() >>> 6;
        }

        private static final class Node<T> {
            final String key;
            final T value;

            /*
             * WARNING - void declaration
             */
            Node(String key, T value) {
                void var2_2;
                void var1_1;
                this.key = var1_1;
                this.value = var2_2;
            }
        }
    }
}

