/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;

public final class HttpHeaderValidationUtil {
    private HttpHeaderValidationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isConnectionHeader(CharSequence name, boolean ignoreTeHeader) {
        int n = name.length();
        switch (n) {
            case 2: {
                void var1_1;
                if (var1_1 != false) {
                    return false;
                }
                return AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)HttpHeaderNames.TE);
            }
            case 7: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)HttpHeaderNames.UPGRADE);
            }
            case 10: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)HttpHeaderNames.CONNECTION) || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)HttpHeaderNames.KEEP_ALIVE);
            }
            case 16: {
                return AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)HttpHeaderNames.PROXY_CONNECTION);
            }
            case 17: {
                CharSequence charSequence;
                return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isTeNotTrailers(CharSequence name, CharSequence value) {
        if (name.length() == 2) {
            void var1_1;
            CharSequence charSequence;
            return AsciiString.contentEqualsIgnoreCase((CharSequence)charSequence, (CharSequence)HttpHeaderNames.TE) && !AsciiString.contentEqualsIgnoreCase((CharSequence)var1_1, (CharSequence)HttpHeaderValues.TRAILERS);
        }
        return false;
    }

    public static int validateValidHeaderValue(CharSequence value) {
        CharSequence charSequence;
        int n = value.length();
        if (n == 0) {
            return -1;
        }
        if (value instanceof AsciiString) {
            return HttpHeaderValidationUtil.verifyValidHeaderValueAsciiString((AsciiString)value);
        }
        return HttpHeaderValidationUtil.verifyValidHeaderValueCharSequence(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    private static int verifyValidHeaderValueAsciiString(AsciiString value) {
        int start;
        byte[] array = value.array();
        int b = array[start = value.arrayOffset()] & 0xFF;
        if (b < 33 || b == 127) {
            return 0;
        }
        int length = value.length();
        for (int i = start + 1; i < length; ++i) {
            void var3_4;
            b = array[i] & 0xFF;
            if ((b >= 32 || b == 9) && var3_4 != 127) continue;
            return i - start;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static int verifyValidHeaderValueCharSequence(CharSequence value) {
        char b = value.charAt(0);
        if (b < '!' || b == '\u007f') {
            return 0;
        }
        int length = value.length();
        for (int i = 1; i < length; ++i) {
            void var1_1;
            b = value.charAt(i);
            if ((b >= ' ' || b == '\t') && var1_1 != 127) continue;
            return i;
        }
        return -1;
    }

    public static int validateToken(CharSequence token) {
        return HttpUtil.validateToken(token);
    }
}

