/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.util.internal.ObjectUtil;

public final class HttpDecoderConfig
implements Cloneable {
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean allowPartialChunks = true;
    private HttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory();
    private HttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory();
    private boolean allowDuplicateContentLengths = false;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int initialBufferSize = 128;

    public final int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setInitialBufferSize(int initialBufferSize) {
        void var1_1;
        ObjectUtil.checkPositive((int)initialBufferSize, (String)"initialBufferSize");
        this.initialBufferSize = var1_1;
        return this;
    }

    public final int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setMaxInitialLineLength(int maxInitialLineLength) {
        void var1_1;
        ObjectUtil.checkPositive((int)maxInitialLineLength, (String)"maxInitialLineLength");
        this.maxInitialLineLength = var1_1;
        return this;
    }

    public final int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setMaxHeaderSize(int maxHeaderSize) {
        void var1_1;
        ObjectUtil.checkPositive((int)maxHeaderSize, (String)"maxHeaderSize");
        this.maxHeaderSize = var1_1;
        return this;
    }

    public final int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setMaxChunkSize(int maxChunkSize) {
        void var1_1;
        ObjectUtil.checkPositive((int)maxChunkSize, (String)"maxChunkSize");
        this.maxChunkSize = var1_1;
        return this;
    }

    public final boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setChunkedSupported(boolean chunkedSupported) {
        void var1_1;
        this.chunkedSupported = var1_1;
        return this;
    }

    public final boolean isAllowPartialChunks() {
        return this.allowPartialChunks;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setAllowPartialChunks(boolean allowPartialChunks) {
        void var1_1;
        this.allowPartialChunks = var1_1;
        return this;
    }

    public final HttpHeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setHeadersFactory(HttpHeadersFactory headersFactory) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)headersFactory, (String)"headersFactory");
        this.headersFactory = var1_1;
        return this;
    }

    public final boolean isAllowDuplicateContentLengths() {
        return this.allowDuplicateContentLengths;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setAllowDuplicateContentLengths(boolean allowDuplicateContentLengths) {
        void var1_1;
        this.allowDuplicateContentLengths = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setValidateHeaders(boolean validateHeaders) {
        void var2_2;
        void var1_1;
        DefaultHttpHeadersFactory noValidation = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        this.headersFactory = validateHeaders ? DefaultHttpHeadersFactory.headersFactory() : noValidation;
        this.trailersFactory = var1_1 != false ? DefaultHttpHeadersFactory.trailersFactory() : var2_2;
        return this;
    }

    public final HttpHeadersFactory getTrailersFactory() {
        return this.trailersFactory;
    }

    /*
     * WARNING - void declaration
     */
    public final HttpDecoderConfig setTrailersFactory(HttpHeadersFactory trailersFactory) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)trailersFactory, (String)"trailersFactory");
        this.trailersFactory = var1_1;
        return this;
    }

    public final HttpDecoderConfig clone() {
        try {
            return (HttpDecoderConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

