/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private EmbeddedChannel encoder;
    private State state = State.AWAIT_HEADERS;

    /*
     * WARNING - void declaration
     */
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return msg instanceof HttpContent || var1_1 instanceof HttpResponse;
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        CharSequence acceptEncoding;
        List<String> acceptEncodingHeaders = msg.headers().getAll((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        switch (acceptEncodingHeaders.size()) {
            case 0: {
                acceptEncoding = HttpContentDecoder.IDENTITY;
                break;
            }
            case 1: {
                acceptEncoding = (CharSequence)acceptEncoding.get(0);
                break;
            }
            default: {
                acceptEncoding = StringUtil.join((CharSequence)",", (Iterable)((Object)acceptEncoding));
            }
        }
        HttpMethod method = msg.method();
        if (HttpMethod.HEAD.equals(method)) {
            acceptEncoding = ZERO_LENGTH_HEAD;
        } else if (HttpMethod.CONNECT.equals(method)) {
            acceptEncoding = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add((CharSequence)var1_1);
        var3_3.add(ReferenceCountUtil.retain((Object)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        boolean isFull = msg instanceof HttpResponse && msg instanceof LastHttpContent;
        switch (this.state) {
            case AWAIT_HEADERS: {
                CharSequence acceptEncoding;
                HttpContentEncoder.ensureHeaders(msg);
                assert (this.encoder == null);
                HttpResponse res = (HttpResponse)msg;
                int code = res.status().code();
                HttpStatusClass httpStatusClass = res.status().codeClass();
                if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                    acceptEncoding = null;
                } else {
                    acceptEncoding = this.acceptEncodingQueue.poll();
                    if (acceptEncoding == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(res.protocolVersion(), code, acceptEncoding)) {
                    if (isFull) {
                        out.add(ReferenceCountUtil.retain((Object)res));
                        return;
                    }
                    out.add(ReferenceCountUtil.retain((Object)res));
                    this.state = State.PASS_THROUGH;
                    return;
                }
                if (isFull && !((ByteBufHolder)res).content().isReadable()) {
                    out.add(ReferenceCountUtil.retain((Object)res));
                    return;
                }
                Result result = this.beginEncode(res, acceptEncoding.toString());
                if (result == null) {
                    if (isFull) {
                        out.add(ReferenceCountUtil.retain((Object)res));
                        return;
                    }
                    out.add(ReferenceCountUtil.retain((Object)res));
                    this.state = State.PASS_THROUGH;
                    return;
                }
                this.encoder = result.contentEncoder();
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)result.targetContentEncoding());
                if (isFull) {
                    void var1_3;
                    DefaultHttpResponse newRes = new DefaultHttpResponse(res.protocolVersion(), res.status());
                    newRes.headers().set(res.headers());
                    out.add(newRes);
                    HttpContentEncoder.ensureContent(res);
                    this.encodeFullResponse((HttpResponse)var1_3, (HttpContent)((Object)res), out);
                    return;
                }
                res.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                out.add(ReferenceCountUtil.retain((Object)res));
                this.state = State.AWAIT_CONTENT;
                if (!(msg instanceof HttpContent)) break;
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(msg);
                if (this.encodeContent((HttpContent)msg, out)) {
                    this.state = State.AWAIT_HEADERS;
                    return;
                }
                if (!out.isEmpty()) break;
                out.add(new DefaultHttpContent(Unpooled.EMPTY_BUFFER));
                return;
            }
            case PASS_THROUGH: {
                void var2_4;
                void var3_5;
                HttpContentEncoder.ensureContent(msg);
                var3_5.add(ReferenceCountUtil.retain((Object)msg));
                if (!(var2_4 instanceof LastHttpContent)) break;
                this.state = State.AWAIT_HEADERS;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeFullResponse(HttpResponse newRes, HttpContent content, List<Object> out) {
        void var1_1;
        int existingMessages = out.size();
        this.encodeContent(content, out);
        if (HttpUtil.isContentLengthSet(newRes)) {
            void var2_3;
            int messageSize = 0;
            for (int i = existingMessages; i < out.size(); ++i) {
                Object item = out.get(i);
                if (!(item instanceof HttpContent)) continue;
                messageSize += ((HttpContent)item).content().readableBytes();
            }
            HttpUtil.setContentLength(newRes, (long)var2_3);
            return;
        }
        var1_1.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPassthru(HttpVersion version, int code, CharSequence httpMethod) {
        HttpVersion httpVersion;
        void var1_1;
        void var2_2;
        return code < 200 || code == 204 || code == 304 || httpMethod == ZERO_LENGTH_HEAD || var2_2 == ZERO_LENGTH_CONNECT && var1_1 == 200 || httpVersion == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject msg) {
        if (!(msg instanceof HttpResponse)) {
            HttpObject httpObject;
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ')');
        }
    }

    private static void ensureContent(HttpObject msg) {
        if (!(msg instanceof HttpContent)) {
            HttpObject httpObject;
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean encodeContent(HttpContent c, List<Object> out) {
        void var3_3;
        ByteBuf content = c.content();
        this.encode((ByteBuf)var3_3, out);
        if (c instanceof LastHttpContent) {
            this.finishEncode(out);
            c = (LastHttpContent)c;
            HttpHeaders headers = c.trailingHeaders();
            if (headers.isEmpty()) {
                out.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                void var1_1;
                void var2_2;
                var2_2.add(new ComposedLastHttpContent((HttpHeaders)var1_1, DecoderResult.SUCCESS));
            }
            return true;
        }
        return false;
    }

    protected abstract Result beginEncode(HttpResponse var1, String var2) throws Exception;

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.cleanupSafely(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.cleanupSafely(ctx);
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.encoder.finishAndReleaseAll();
            this.encoder = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupSafely(ChannelHandlerContext ctx) {
        try {
            this.cleanup();
            return;
        }
        catch (Throwable cause) {
            void var2_2;
            void var1_1;
            var1_1.fireExceptionCaught((Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encode(ByteBuf in, List<Object> out) {
        void var2_2;
        void var1_1;
        this.encoder.writeOutbound(new Object[]{var1_1.retain()});
        this.fetchEncoderOutput((List<Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void finishEncode(List<Object> out) {
        if (this.encoder.finish()) {
            void var1_1;
            this.fetchEncoderOutput((List<Object>)var1_1);
        }
        this.encoder = null;
    }

    /*
     * WARNING - void declaration
     */
    private void fetchEncoderOutput(List<Object> out) {
        ByteBuf buf;
        while ((buf = (ByteBuf)this.encoder.readOutbound()) != null) {
            void var2_2;
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            out.add(new DefaultHttpContent((ByteBuf)var2_2));
        }
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EmbeddedChannel contentEncoder;

        /*
         * WARNING - void declaration
         */
        public Result(String targetContentEncoding, EmbeddedChannel contentEncoder) {
            void var2_2;
            void var1_1;
            this.targetContentEncoding = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"targetContentEncoding");
            this.contentEncoder = (EmbeddedChannel)ObjectUtil.checkNotNull((Object)var2_2, (String)"contentEncoder");
        }

        public final String targetContentEncoding() {
            return this.targetContentEncoding;
        }

        public final EmbeddedChannel contentEncoder() {
            return this.contentEncoder;
        }
    }

    private static enum State {
        PASS_THROUGH,
        AWAIT_HEADERS,
        AWAIT_CONTENT;

    }
}

