/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdDecoder;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public HttpContentDecompressor(boolean strict) {
        void var1_1;
        this.strict = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        void var1_1;
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)var1_1)});
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase((CharSequence)var1_1)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ChannelHandler[]{new BrotliDecoder()});
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase((CharSequence)var1_1)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ChannelHandler[]{new SnappyFrameDecoder()});
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase((CharSequence)var1_1)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new ChannelHandler[]{new ZstdDecoder()});
        }
        return null;
    }
}

