/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;
    private boolean needRead = true;

    /*
     * Unable to fully structure code
     */
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        block24: {
            block23: {
                block22: {
                    try {
                        if (!(msg instanceof HttpResponse) || ((HttpResponse)msg).status().code() != 100) break block22;
                        if (!(msg instanceof LastHttpContent)) {
                            this.continueResponse = true;
                        }
                        out.add(ReferenceCountUtil.retain((Object)msg));
                        this.needRead = out.isEmpty();
                        return;
                    }
                    catch (Throwable var1_2) {
                        this.needRead = var3_4.isEmpty();
                        throw var1_2;
                    }
                }
                if (!this.continueResponse) break block23;
                if (msg instanceof LastHttpContent) {
                    this.continueResponse = false;
                }
                out.add(ReferenceCountUtil.retain((Object)msg));
                this.needRead = out.isEmpty();
                return;
            }
            if (!(msg instanceof HttpMessage)) ** GOTO lbl73
            this.cleanup();
            message = (HttpMessage)msg;
            headers = message.headers();
            contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding != null) {
                contentEncoding = contentEncoding.trim();
            } else {
                transferEncoding = headers.get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                transferEncoding = transferEncoding != null ? ((idx = transferEncoding.indexOf(",")) != -1 ? transferEncoding.substring(0, idx).trim() : transferEncoding.trim()) : HttpContentDecoder.IDENTITY;
            }
            this.decoder = this.newContentDecoder(transferEncoding);
            if (this.decoder != null) break block24;
            if (message instanceof HttpContent) {
                ((HttpContent)message).retain();
            }
            out.add(message);
            this.needRead = out.isEmpty();
            return;
        }
        if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if (HttpHeaderValues.IDENTITY.contentEquals((CharSequence)(targetContentEncoding = this.getTargetContentEncoding(transferEncoding)))) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)targetContentEncoding);
        }
        if (message instanceof HttpContent) {
            if (message instanceof HttpRequest) {
                r = (HttpRequest)message;
                copy = new DefaultHttpRequest(r.protocolVersion(), r.method(), r.uri());
            } else if (message instanceof HttpResponse) {
                r = (HttpResponse)message;
                copy = new DefaultHttpResponse(r.protocolVersion(), r.status());
            } else {
                throw new CodecException("Object of class " + message.getClass().getName() + " is not an HttpRequest or HttpResponse");
            }
            copy.headers().set(message.headers());
            copy.setDecoderResult(message.decoderResult());
            out.add(copy);
        } else {
            out.add(message);
        }
lbl73:
        // 3 sources

        if (msg instanceof HttpContent) {
            c = (HttpContent)var2_3;
            if (this.decoder == null) {
                out.add(c.retain());
            } else {
                this.decodeContent((HttpContent)var1_1, out);
            }
        }
        this.needRead = out.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void decodeContent(HttpContent c, List<Object> out) {
        void var3_3;
        ByteBuf content = c.content();
        this.decode((ByteBuf)var3_3, out);
        if (c instanceof LastHttpContent) {
            void var1_1;
            void var2_2;
            this.finishDecode(out);
            c = (LastHttpContent)c;
            HttpHeaders headers = c.trailingHeaders();
            if (headers.isEmpty()) {
                out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                return;
            }
            var2_2.add(new ComposedLastHttpContent((HttpHeaders)var1_1, DecoderResult.SUCCESS));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        boolean needRead = this.needRead;
        this.needRead = true;
        try {
            ctx.fireChannelReadComplete();
        }
        catch (Throwable throwable) {
            void var2_2;
            if (var2_2 != false && !ctx.channel().config().isAutoRead()) {
                void var1_1;
                var1_1.read();
            }
            throw throwable;
        }
        if (needRead && !ctx.channel().config().isAutoRead()) {
            ctx.read();
            return;
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return IDENTITY;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.cleanupSafely(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.cleanupSafely(ctx);
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = ctx;
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupSafely(ChannelHandlerContext ctx) {
        try {
            this.cleanup();
            return;
        }
        catch (Throwable cause) {
            void var2_2;
            void var1_1;
            var1_1.fireExceptionCaught((Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decode(ByteBuf in, List<Object> out) {
        void var2_2;
        void var1_1;
        this.decoder.writeInbound(new Object[]{var1_1.retain()});
        this.fetchDecoderOutput((List<Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void finishDecode(List<Object> out) {
        if (this.decoder.finish()) {
            void var1_1;
            this.fetchDecoderOutput((List<Object>)var1_1);
        }
        this.decoder = null;
    }

    /*
     * WARNING - void declaration
     */
    private void fetchDecoderOutput(List<Object> out) {
        ByteBuf buf;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            void var2_2;
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            out.add(new DefaultHttpContent((ByteBuf)var2_2));
        }
    }
}

