/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class HttpClientUpgradeHandler
extends HttpObjectAggregator
implements ChannelOutboundHandler {
    private final SourceCodec sourceCodec;
    private final UpgradeCodec upgradeCodec;
    private UpgradeEvent currentUpgradeEvent;

    /*
     * WARNING - void declaration
     */
    public HttpClientUpgradeHandler(SourceCodec sourceCodec, UpgradeCodec upgradeCodec, int maxContentLength) {
        super((int)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.sourceCodec = (SourceCodec)ObjectUtil.checkNotNull((Object)var1_1, (String)"sourceCodec");
        this.upgradeCodec = (UpgradeCodec)ObjectUtil.checkNotNull((Object)var2_2, (String)"upgradeCodec");
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        if (!(msg instanceof HttpRequest) || this.currentUpgradeEvent == UpgradeEvent.UPGRADE_SUCCESSFUL) {
            ctx.write(msg, promise);
            return;
        }
        if (this.currentUpgradeEvent == UpgradeEvent.UPGRADE_ISSUED) {
            ReferenceCountUtil.release((Object)msg);
            promise.setFailure((Throwable)new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
            return;
        }
        this.currentUpgradeEvent = UpgradeEvent.UPGRADE_ISSUED;
        this.setUpgradeRequestHeaders(ctx, (HttpRequest)msg);
        ctx.write((Object)var2_2, (ChannelPromise)var3_3);
        var1_1.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_ISSUED);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        FullHttpResponse response = null;
        try {
            void var3_3;
            HttpResponse rep;
            if (this.currentUpgradeEvent != UpgradeEvent.UPGRADE_ISSUED) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (msg instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((rep = (HttpResponse)msg).status())) {
                this.currentUpgradeEvent = null;
                ctx.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_REJECTED);
                HttpClientUpgradeHandler.removeThisHandler(ctx);
                ctx.fireChannelRead((Object)msg);
                return;
            }
            if (msg instanceof FullHttpResponse) {
                response = (FullHttpResponse)msg;
                response.retain();
                out.add(response);
            } else {
                void var2_2;
                super.decode(ctx, (Object)var2_2, out);
                if (out.isEmpty()) {
                    return;
                }
                assert (out.size() == 1);
                response = (FullHttpResponse)out.get(0);
            }
            String upgradeHeader = response.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
            if (upgradeHeader != null && !AsciiString.contentEqualsIgnoreCase((CharSequence)this.upgradeCodec.protocol(), (CharSequence)upgradeHeader)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + upgradeHeader);
            }
            this.sourceCodec.prepareUpgradeFrom(ctx);
            this.upgradeCodec.upgradeTo(ctx, response);
            this.currentUpgradeEvent = UpgradeEvent.UPGRADE_SUCCESSFUL;
            ctx.fireUserEventTriggered((Object)UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(ctx);
            response.release();
            var3_3.clear();
            HttpClientUpgradeHandler.removeThisHandler(ctx);
            return;
        }
        catch (Throwable t) {
            void var1_1;
            ReferenceCountUtil.release(response);
            ctx.fireExceptionCaught(t);
            HttpClientUpgradeHandler.removeThisHandler((ChannelHandlerContext)var1_1);
            return;
        }
    }

    private static void removeThisHandler(ChannelHandlerContext ctx) {
        ChannelHandlerContext channelHandlerContext;
        ctx.pipeline().remove(channelHandlerContext.name());
    }

    /*
     * WARNING - void declaration
     */
    private void setUpgradeRequestHeaders(ChannelHandlerContext ctx, HttpRequest request) {
        void var1_1;
        void var2_2;
        Iterator iterator;
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgradeCodec.protocol());
        LinkedHashSet<CharSequence> connectionParts = new LinkedHashSet<CharSequence>(2);
        connectionParts.addAll(this.upgradeCodec.setUpgradeHeaders(ctx, request));
        StringBuilder builder = new StringBuilder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            CharSequence part = (CharSequence)iterator.next();
            builder.append(part);
            builder.append(',');
        }
        builder.append((CharSequence)HttpHeaderValues.UPGRADE);
        var2_2.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)var1_1.toString());
    }

    public static interface UpgradeCodec {
        public CharSequence protocol();

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpResponse var2) throws Exception;
    }

    public static interface SourceCodec {
        public void prepareUpgradeFrom(ChannelHandlerContext var1);

        public void upgradeFrom(ChannelHandlerContext var1);
    }

    public static enum UpgradeEvent {
        UPGRADE_ISSUED,
        UPGRADE_SUCCESSFUL,
        UPGRADE_REJECTED;

    }
}

