/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder>
implements HttpClientUpgradeHandler.SourceCodec {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(new HttpDecoderConfig(), false, false);
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3), false, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3), false, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders), false, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders, boolean parseHttpAfterConnectRequest) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders), parseHttpAfterConnectRequest, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize), false, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize, boolean parseHttpAfterConnectRequest) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize), parseHttpAfterConnectRequest, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize, boolean parseHttpAfterConnectRequest, boolean allowDuplicateContentLengths) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths), parseHttpAfterConnectRequest, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize, boolean parseHttpAfterConnectRequest, boolean allowDuplicateContentLengths, boolean allowPartialChunks) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths).setAllowPartialChunks(allowPartialChunks), parseHttpAfterConnectRequest, failOnMissingResponse);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientCodec(HttpDecoderConfig config, boolean parseHttpAfterConnectRequest, boolean failOnMissingResponse) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((ChannelInboundHandler)new Decoder((HttpDecoderConfig)var1_1), (ChannelOutboundHandler)new Encoder());
        this.parseHttpAfterConnectRequest = var2_2;
        this.failOnMissingResponse = var3_3;
    }

    @Override
    public final void prepareUpgradeFrom(ChannelHandlerContext ctx) {
        ((Encoder)this.outboundHandler()).upgraded = true;
    }

    @Override
    public final void upgradeFrom(ChannelHandlerContext ctx) {
        ChannelPipeline channelPipeline = ctx.pipeline();
        channelPipeline.remove((ChannelHandler)this);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSingleDecode(boolean singleDecode) {
        void var1_1;
        ((HttpResponseDecoder)this.inboundHandler()).setSingleDecode((boolean)var1_1);
    }

    public final boolean isSingleDecode() {
        return ((HttpResponseDecoder)this.inboundHandler()).isSingleDecode();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(HttpClientCodec x0, boolean x1) {
        void var1_1;
        x0.done = var1_1;
        return x0.done;
    }

    private final class Decoder
    extends HttpResponseDecoder {
        /*
         * WARNING - void declaration
         */
        Decoder(HttpDecoderConfig config) {
            void var2_2;
            super((HttpDecoderConfig)var2_2);
        }

        @Override
        protected final void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            if (HttpClientCodec.this.done) {
                int readable = this.actualReadableBytes();
                if (readable == 0) {
                    return;
                }
                out.add(buffer.readBytes(readable));
                return;
            }
            int oldSize = out.size();
            super.decode(ctx, buffer, out);
            if (HttpClientCodec.this.failOnMissingResponse) {
                int size = out.size();
                for (int i = oldSize; i < size; ++i) {
                    this.decrement(out.get(i));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void decrement(Object msg) {
            void var1_1;
            if (msg == null) {
                return;
            }
            if (var1_1 instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final boolean isContentAlwaysEmpty(HttpMessage msg) {
            void var1_1;
            HttpMethod method = (HttpMethod)HttpClientCodec.this.queue.poll();
            HttpResponseStatus status = ((HttpResponse)msg).status();
            HttpStatusClass statusClass = status.codeClass();
            int statusCode = status.code();
            if (statusClass == HttpStatusClass.INFORMATIONAL) {
                return super.isContentAlwaysEmpty(msg);
            }
            if (method != null) {
                char c = method.name().charAt(0);
                switch (c) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(method)) break;
                        return true;
                    }
                    case 'C': {
                        void var2_2;
                        void var3_4;
                        if (var3_4 != 200 || !HttpMethod.CONNECT.equals(var2_2)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.access$302(HttpClientCodec.this, true);
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty((HttpMessage)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
            long missingResponses;
            super.channelInactive(ctx);
            if (HttpClientCodec.this.failOnMissingResponse && (missingResponses = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                void var2_2;
                void var1_1;
                var1_1.fireExceptionCaught((Throwable)new PrematureChannelClosureException("channel gone inactive with " + (long)var2_2 + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            void var2_2;
            void var3_3;
            void var1_1;
            if (this.upgraded) {
                out.add(msg);
                return;
            }
            if (msg instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).method());
            }
            super.encode((ChannelHandlerContext)var1_1, msg, (List<Object>)var3_3);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && var2_2 instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

