/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;

public class HttpChunkedInput
implements ChunkedInput<HttpContent> {
    private final ChunkedInput<ByteBuf> input;
    private final LastHttpContent lastHttpContent;
    private boolean sentLastChunk;

    /*
     * WARNING - void declaration
     */
    public HttpChunkedInput(ChunkedInput<ByteBuf> input) {
        void var1_1;
        this.input = var1_1;
        this.lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
    }

    /*
     * WARNING - void declaration
     */
    public HttpChunkedInput(ChunkedInput<ByteBuf> input, LastHttpContent lastHttpContent) {
        void var2_2;
        void var1_1;
        this.input = var1_1;
        this.lastHttpContent = var2_2;
    }

    public boolean isEndOfInput() throws Exception {
        if (this.input.isEndOfInput()) {
            return this.sentLastChunk;
        }
        return false;
    }

    public void close() throws Exception {
        this.input.close();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    public HttpContent readChunk(ByteBufAllocator allocator) throws Exception {
        void var1_1;
        if (this.input.isEndOfInput()) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return this.lastHttpContent;
        }
        ByteBuf buf = (ByteBuf)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        return new DefaultHttpContent((ByteBuf)var1_1);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

