/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.CombinedHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.util.internal.ObjectUtil;

public final class DefaultHttpHeadersFactory
implements HttpHeadersFactory {
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        /*
         * WARNING - void declaration
         */
        public final void validateName(CharSequence name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("empty headers are not allowed [" + name + ']');
            }
            int index = HttpHeaderValidationUtil.validateToken(name);
            if (index != -1) {
                void var1_1;
                void var2_2;
                throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(name.charAt(index)) + " at index " + (int)var2_2 + " of header '" + var1_1 + "'.");
            }
        }
    };
    private static final DefaultHeaders.ValueValidator<CharSequence> DEFAULT_VALUE_VALIDATOR = new DefaultHeaders.ValueValidator<CharSequence>(){

        /*
         * WARNING - void declaration
         */
        public final void validate(CharSequence value) {
            int index = HttpHeaderValidationUtil.validateValidHeaderValue(value);
            if (index != -1) {
                void var2_2;
                void var1_1;
                throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(var1_1.charAt(index)) + " at index " + (int)var2_2 + '.');
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_TRAILER_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        /*
         * WARNING - void declaration
         */
        public final void validateName(CharSequence name) {
            DEFAULT_NAME_VALIDATOR.validateName((Object)name);
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(name) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(name) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(name)) {
                void var1_1;
                throw new IllegalArgumentException("prohibited trailing header: " + var1_1);
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> NO_NAME_VALIDATOR = DefaultHeaders.NameValidator.NOT_NULL;
    private static final DefaultHeaders.ValueValidator<CharSequence> NO_VALUE_VALIDATOR = DefaultHeaders.ValueValidator.NO_VALIDATION;
    private static final DefaultHttpHeadersFactory DEFAULT = new DefaultHttpHeadersFactory(DEFAULT_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_TRAILER = new DefaultHttpHeadersFactory(DEFAULT_TRAILER_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_COMBINING = new DefaultHttpHeadersFactory(DefaultHttpHeadersFactory.DEFAULT.nameValidator, DefaultHttpHeadersFactory.DEFAULT.valueValidator, true);
    private static final DefaultHttpHeadersFactory DEFAULT_NO_VALIDATION = new DefaultHttpHeadersFactory(NO_NAME_VALIDATOR, NO_VALUE_VALIDATOR, false);
    private final DefaultHeaders.NameValidator<CharSequence> nameValidator;
    private final DefaultHeaders.ValueValidator<CharSequence> valueValidator;
    private final boolean combiningHeaders;

    /*
     * WARNING - void declaration
     */
    private DefaultHttpHeadersFactory(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, boolean combiningHeaders) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.nameValidator = (DefaultHeaders.NameValidator)ObjectUtil.checkNotNull((Object)var1_1, (String)"nameValidator");
        this.valueValidator = (DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull((Object)var2_2, (String)"valueValidator");
        this.combiningHeaders = var3_3;
    }

    public static DefaultHttpHeadersFactory headersFactory() {
        return DEFAULT;
    }

    public static DefaultHttpHeadersFactory trailersFactory() {
        return DEFAULT_TRAILER;
    }

    @Override
    public final HttpHeaders newHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator());
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator());
    }

    @Override
    public final HttpHeaders newEmptyHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withNameValidation(boolean validation) {
        void var1_1;
        return this.withNameValidator(var1_1 != false ? DEFAULT_NAME_VALIDATOR : NO_NAME_VALIDATOR);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withNameValidator(DefaultHeaders.NameValidator<CharSequence> validator) {
        void var1_1;
        if (this.nameValidator == ObjectUtil.checkNotNull(validator, (String)"validator")) {
            return this;
        }
        if (validator == DEFAULT_NAME_VALIDATOR && this.valueValidator == DEFAULT_VALUE_VALIDATOR) {
            if (this.combiningHeaders) {
                return DEFAULT_COMBINING;
            }
            return DEFAULT;
        }
        return new DefaultHttpHeadersFactory((DefaultHeaders.NameValidator<CharSequence>)var1_1, this.valueValidator, this.combiningHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withValueValidation(boolean validation) {
        void var1_1;
        return this.withValueValidator(var1_1 != false ? DEFAULT_VALUE_VALIDATOR : NO_VALUE_VALIDATOR);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withValueValidator(DefaultHeaders.ValueValidator<CharSequence> validator) {
        void var1_1;
        if (this.valueValidator == ObjectUtil.checkNotNull(validator, (String)"validator")) {
            return this;
        }
        if (this.nameValidator == DEFAULT_NAME_VALIDATOR && validator == DEFAULT_VALUE_VALIDATOR) {
            if (this.combiningHeaders) {
                return DEFAULT_COMBINING;
            }
            return DEFAULT;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, (DefaultHeaders.ValueValidator<CharSequence>)var1_1, this.combiningHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withValidation(boolean validation) {
        void var1_1;
        if (this == DEFAULT && !validation) {
            return DEFAULT_NO_VALIDATION;
        }
        if (this == DEFAULT_NO_VALIDATION && validation) {
            return DEFAULT;
        }
        return this.withNameValidation(validation).withValueValidation((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultHttpHeadersFactory withCombiningHeaders(boolean combiningHeaders) {
        void var1_1;
        if (this.combiningHeaders == combiningHeaders) {
            return this;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, this.valueValidator, (boolean)var1_1);
    }

    public final DefaultHeaders.NameValidator<CharSequence> getNameValidator() {
        return this.nameValidator;
    }

    public final DefaultHeaders.ValueValidator<CharSequence> getValueValidator() {
        return this.valueValidator;
    }

    public final boolean isCombiningHeaders() {
        return this.combiningHeaders;
    }

    public final boolean isValidatingHeaderNames() {
        return this.nameValidator != NO_NAME_VALIDATOR;
    }

    public final boolean isValidatingHeaderValues() {
        return this.valueValidator != NO_VALUE_VALIDATOR;
    }
}

