/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeadersImpl;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(DefaultHttpHeaders.nameValidator(true), DefaultHttpHeaders.valueValidator(true));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultHttpHeaders(boolean validate) {
        this(DefaultHttpHeaders.nameValidator(validate), DefaultHttpHeaders.valueValidator((boolean)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultHttpHeaders(boolean validateValues, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        this((DefaultHeaders.NameValidator<CharSequence>)var2_2, DefaultHttpHeaders.valueValidator((boolean)var1_1));
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        this((DefaultHeaders.NameValidator<CharSequence>)var1_1, (DefaultHeaders.ValueValidator<CharSequence>)var2_2, 16);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int sizeHint) {
        this((DefaultHeaders<CharSequence, CharSequence, ?>)new DefaultHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, (ValueConverter)HeaderValueConverter.INSTANCE, (DefaultHeaders.NameValidator)var1_1, (int)var3_3, (DefaultHeaders.ValueValidator)var2_2));
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> headers) {
        void var1_1;
        this.headers = var1_1;
    }

    public Headers<CharSequence, CharSequence, ?> unwrap() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders add(HttpHeaders headers) {
        void var1_1;
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.add((HttpHeaders)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders set(HttpHeaders headers) {
        void var1_1;
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.set((HttpHeaders)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders add(String name, Object value) {
        void var2_2;
        void var1_1;
        this.headers.addObject((Object)var1_1, (Object)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders add(CharSequence name, Object value) {
        void var2_2;
        void var1_1;
        this.headers.addObject((Object)var1_1, (Object)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders add(String name, Iterable<?> values) {
        void var2_2;
        void var1_1;
        this.headers.addObject((Object)var1_1, (Iterable)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        void var2_2;
        void var1_1;
        this.headers.addObject((Object)var1_1, (Iterable)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders addInt(CharSequence name, int value) {
        void var2_2;
        void var1_1;
        this.headers.addInt((Object)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders addShort(CharSequence name, short value) {
        void var2_2;
        void var1_1;
        this.headers.addShort((Object)var1_1, (short)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders remove(String name) {
        void var1_1;
        this.headers.remove((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders remove(CharSequence name) {
        void var1_1;
        this.headers.remove((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders set(String name, Object value) {
        void var2_2;
        void var1_1;
        this.headers.setObject((Object)var1_1, (Object)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders set(CharSequence name, Object value) {
        void var2_2;
        void var1_1;
        this.headers.setObject((Object)var1_1, (Object)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders set(String name, Iterable<?> values) {
        void var2_2;
        void var1_1;
        this.headers.setObject((Object)var1_1, (Iterable)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        void var2_2;
        void var1_1;
        this.headers.setObject((Object)var1_1, (Iterable)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders setInt(CharSequence name, int value) {
        void var2_2;
        void var1_1;
        this.headers.setInt((Object)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpHeaders setShort(CharSequence name, short value) {
        void var2_2;
        void var1_1;
        this.headers.setShort((Object)var1_1, (short)var2_2);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(String name) {
        void var1_1;
        return ((HttpHeaders)this).get((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(CharSequence name) {
        void var1_1;
        return HeadersUtils.getAsString(this.headers, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer getInt(CharSequence name) {
        void var1_1;
        return this.headers.getInt((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(CharSequence name, int defaultValue) {
        void var2_2;
        void var1_1;
        return this.headers.getInt((Object)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Short getShort(CharSequence name) {
        void var1_1;
        return this.headers.getShort((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(CharSequence name, short defaultValue) {
        void var2_2;
        void var1_1;
        return this.headers.getShort((Object)var1_1, (short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long getTimeMillis(CharSequence name) {
        void var1_1;
        return this.headers.getTimeMillis((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        void var2_2;
        void var1_1;
        return this.headers.getTimeMillis((Object)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getAll(String name) {
        void var1_1;
        return ((HttpHeaders)this).getAll((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getAll(CharSequence name) {
        void var1_1;
        return HeadersUtils.getAllAsString(this.headers, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Map.Entry<String, String>> entries() {
        void var1_1;
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<void> entriesConverted = new ArrayList<void>(this.headers.size());
        for (Map.Entry<String, String> entry : this) {
            void var3_3;
            entriesConverted.add(var3_3);
        }
        return var1_1;
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<String> valueStringIterator(CharSequence name) {
        void var1_1;
        Iterator<? extends CharSequence> itr = ((HttpHeaders)this).valueCharSequenceIterator(name);
        return new Iterator<String>(this, (Iterator)var1_1){
            final /* synthetic */ Iterator val$itr;
            final /* synthetic */ DefaultHttpHeaders this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$itr = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$itr.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)this.val$itr.next()).toString();
            }

            @Override
            public void remove() {
                this.val$itr.remove();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence name) {
        void var1_1;
        return this.headers.valueIterator((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(String name) {
        void var1_1;
        return ((HttpHeaders)this).contains((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(CharSequence name) {
        void var1_1;
        return this.headers.contains((Object)var1_1);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ((HttpHeaders)this).contains((CharSequence)var1_1, (CharSequence)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.headers.contains((Object)var1_1, (Object)var2_2, var3_3 != false ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)var1_1).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.ValueValidator<CharSequence> valueValidator(boolean validate) {
        if (validate) {
            return DefaultHttpHeadersFactory.headersFactory().getValueValidator();
        }
        return DefaultHttpHeadersFactory.headersFactory().withValidation(false).getValueValidator();
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean validate) {
        if (validate) {
            return DefaultHttpHeadersFactory.headersFactory().getNameValidator();
        }
        return DefaultHttpHeadersFactory.headersFactory().withNameValidation(false).getNameValidator();
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        /*
         * WARNING - void declaration
         */
        public CharSequence convertObject(Object value) {
            void var1_1;
            if (value instanceof CharSequence) {
                return (CharSequence)value;
            }
            if (value instanceof Date) {
                return DateFormatter.format((Date)((Date)value));
            }
            if (value instanceof Calendar) {
                return DateFormatter.format((Date)((Calendar)value).getTime());
            }
            return var1_1.toString();
        }
    }
}

