/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final ByteBuf content;
    private final HttpHeaders trailingHeaders;
    private int hash;

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, (ByteBuf)var3_3, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, boolean validateHeaders) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation((boolean)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, boolean validateHeaders, boolean singleFieldHeaders) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders).withCombiningHeaders(singleFieldHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation((boolean)var3_3).withCombiningHeaders(singleFieldHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, boolean validateHeaders) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, (ByteBuf)var3_3, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, boolean validateHeaders, boolean singleFieldHeaders) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, (ByteBuf)var3_3, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders).withCombiningHeaders(singleFieldHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders).withCombiningHeaders(singleFieldHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, HttpHeadersFactory headersFactory, HttpHeadersFactory trailersFactory) {
        this((HttpVersion)var1_1, (HttpResponseStatus)var2_2, (ByteBuf)var3_3, headersFactory.newHeaders(), trailersFactory.newHeaders());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content, HttpHeaders headers, HttpHeaders trailingHeaders) {
        super((HttpVersion)var1_1, (HttpResponseStatus)var2_2, headers);
        void var3_3;
        void var2_2;
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)var3_3, (String)"content");
        this.trailingHeaders = (HttpHeaders)ObjectUtil.checkNotNull((Object)trailingHeaders, (String)"trailingHeaders");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpResponse retain() {
        this.content.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpResponse retain(int increment) {
        void var1_1;
        this.content.retain((int)var1_1);
        return this;
    }

    @Override
    public FullHttpResponse touch() {
        this.content.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpResponse touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(int decrement) {
        void var1_1;
        return this.content.release((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpResponse setProtocolVersion(HttpVersion version) {
        void var1_1;
        super.setProtocolVersion((HttpVersion)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpResponse setStatus(HttpResponseStatus status) {
        void var1_1;
        super.setStatus((HttpResponseStatus)var1_1);
        return this;
    }

    @Override
    public FullHttpResponse copy() {
        DefaultFullHttpResponse defaultFullHttpResponse = this;
        return defaultFullHttpResponse.replace(defaultFullHttpResponse.content().copy());
    }

    @Override
    public FullHttpResponse duplicate() {
        DefaultFullHttpResponse defaultFullHttpResponse = this;
        return defaultFullHttpResponse.replace(defaultFullHttpResponse.content().duplicate());
    }

    @Override
    public FullHttpResponse retainedDuplicate() {
        DefaultFullHttpResponse defaultFullHttpResponse = this;
        return defaultFullHttpResponse.replace(defaultFullHttpResponse.content().retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpResponse replace(ByteBuf content) {
        void var1_1;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.protocolVersion(), this.status(), content, this.headers().copy(), this.trailingHeaders().copy());
        response.setDecoderResult(this.decoderResult());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hash = this.hash;
        if (hash == 0) {
            if (ByteBufUtil.isAccessible((ByteBuf)this.content())) {
                try {
                    hash = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            hash = 31;
            hash = hash * 31 + this.trailingHeaders().hashCode();
            this.hash = hash = hash * 31 + super.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof DefaultFullHttpResponse)) {
            return false;
        }
        DefaultFullHttpResponse other = (DefaultFullHttpResponse)o;
        return super.equals(other) && this.content().equals((Object)other.content()) && this.trailingHeaders().equals(var1_1.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

