/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final ByteBuf content;
    private final HttpHeaders trailingHeader;
    private int hash;

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        this((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content) {
        this((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, content, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, boolean validateHeaders) {
        this((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content, boolean validateHeaders) {
        this((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, content, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content, HttpHeadersFactory headersFactory, HttpHeadersFactory trailersFactory) {
        this((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, content, headersFactory.newHeaders(), trailersFactory.newHeaders());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, ByteBuf content, HttpHeaders headers, HttpHeaders trailingHeader) {
        super((HttpVersion)var1_1, (HttpMethod)var2_2, (String)var3_3, headers);
        void var3_3;
        void var2_2;
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)content, (String)"content");
        this.trailingHeader = (HttpHeaders)ObjectUtil.checkNotNull((Object)trailingHeader, (String)"trailingHeader");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest retain(int increment) {
        void var1_1;
        this.content.retain((int)var1_1);
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(int decrement) {
        void var1_1;
        return this.content.release((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion version) {
        void var1_1;
        super.setProtocolVersion((HttpVersion)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest setMethod(HttpMethod method) {
        void var1_1;
        super.setMethod((HttpMethod)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest setUri(String uri) {
        void var1_1;
        super.setUri((String)var1_1);
        return this;
    }

    @Override
    public FullHttpRequest copy() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().copy());
    }

    @Override
    public FullHttpRequest duplicate() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().duplicate());
    }

    @Override
    public FullHttpRequest retainedDuplicate() {
        DefaultFullHttpRequest defaultFullHttpRequest = this;
        return defaultFullHttpRequest.replace(defaultFullHttpRequest.content().retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FullHttpRequest replace(ByteBuf content) {
        void var1_1;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), content, this.headers().copy(), this.trailingHeaders().copy());
        request.setDecoderResult(this.decoderResult());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hash = this.hash;
        if (hash == 0) {
            if (ByteBufUtil.isAccessible((ByteBuf)this.content())) {
                try {
                    hash = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            hash = 31;
            hash = hash * 31 + this.trailingHeaders().hashCode();
            this.hash = hash = hash * 31 + super.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof DefaultFullHttpRequest)) {
            return false;
        }
        DefaultFullHttpRequest other = (DefaultFullHttpRequest)o;
        return super.equals(other) && this.content().equals((Object)other.content()) && this.trailingHeaders().equals(var1_1.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

