/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    /*
     * WARNING - void declaration
     */
    @Deprecated
    public CombinedHttpHeaders(boolean validate) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), CombinedHttpHeaders.nameValidator(validate), CombinedHttpHeaders.valueValidator((boolean)var1_1)));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), (DefaultHeaders.NameValidator<CharSequence>)((DefaultHeaders.NameValidator)ObjectUtil.checkNotNull((Object)var1_1, (String)"nameValidator")), (DefaultHeaders.ValueValidator<CharSequence>)((DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull((Object)var2_2, (String)"valueValidator"))));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    CombinedHttpHeaders(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int sizeHint) {
        super(new CombinedHttpHeadersImpl((HashingStrategy<CharSequence>)AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(), (DefaultHeaders.NameValidator<CharSequence>)((DefaultHeaders.NameValidator)ObjectUtil.checkNotNull((Object)var1_1, (String)"nameValidator")), (DefaultHeaders.ValueValidator<CharSequence>)((DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull((Object)var2_2, (String)"valueValidator")), (int)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.containsValue((CharSequence)var1_1, StringUtil.trimOws((CharSequence)var2_2), (boolean)var3_3);
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private static final int VALUE_LENGTH_ESTIMATE = 10;
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(this){
                    final /* synthetic */ CombinedHttpHeadersImpl this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public CharSequence escape(CharSequence name, Object value) {
                        void var2_2;
                        try {
                            CharSequence converted = (CharSequence)this.this$0.valueConverter().convertObject(value);
                        }
                        catch (IllegalArgumentException e) {
                            void var1_1;
                            throw new IllegalArgumentException("Failed to convert object value for header '" + var1_1 + '\'', e);
                        }
                        return StringUtil.escapeCsv((CharSequence)var2_2, (boolean)true);
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(this){
                    final /* synthetic */ CombinedHttpHeadersImpl this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public CharSequence escape(CharSequence name, CharSequence value) {
                        return StringUtil.escapeCsv((CharSequence)value, (boolean)true);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        /*
         * WARNING - void declaration
         */
        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> nameHashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
            this((HashingStrategy<CharSequence>)var1_1, (ValueConverter<CharSequence>)var2_2, (DefaultHeaders.NameValidator<CharSequence>)var3_3, valueValidator, 16);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        CombinedHttpHeadersImpl(HashingStrategy<CharSequence> nameHashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, int sizeHint) {
            super((HashingStrategy)var1_1, (ValueConverter)var2_2, (DefaultHeaders.NameValidator)var3_3, sizeHint, valueValidator);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final Iterator<CharSequence> valueIterator(CharSequence name) {
            void var1_1;
            void var2_2;
            Iterator itr = super.valueIterator((Object)name);
            if (!itr.hasNext() || CombinedHttpHeadersImpl.cannotBeCombined(name)) {
                return itr;
            }
            Iterator unescapedItr = StringUtil.unescapeCsvFields((CharSequence)((CharSequence)itr.next())).iterator();
            if (var2_2.hasNext()) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final List<CharSequence> getAll(CharSequence name) {
            void var2_2;
            void var1_1;
            List values = super.getAll((Object)name);
            if (values.isEmpty() || CombinedHttpHeadersImpl.cannotBeCombined((CharSequence)var1_1)) {
                return values;
            }
            if (values.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields((CharSequence)((CharSequence)var2_2.get(0)));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl((Headers)headers);
                } else {
                    headers = headers.iterator();
                    while (headers.hasNext()) {
                        Map.Entry header = (Map.Entry)headers.next();
                        this.addEscapedValue((CharSequence)header.getKey(), (CharSequence)header.getValue());
                    }
                }
            } else {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_3;
                    Map.Entry header = (Map.Entry)iterator.next();
                    this.add((CharSequence)header.getKey(), (CharSequence)var2_3.getValue());
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            void var1_1;
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add((Headers<? extends CharSequence, ? extends CharSequence, ?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            void var1_1;
            if (headers == this) {
                return this;
            }
            for (CharSequence key : headers.names()) {
                void var3_3;
                this.remove(var3_3);
            }
            return this.add((Headers<? extends CharSequence, ? extends CharSequence, ?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl add(CharSequence name, CharSequence value) {
            void var2_2;
            void var1_1;
            return this.addEscapedValue(name, this.charSequenceEscaper().escape((CharSequence)var1_1, (CharSequence)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl add(CharSequence name, CharSequence ... values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.addEscapedValue((CharSequence)v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.charSequenceEscaper(), var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl add(CharSequence name, Iterable<? extends CharSequence> values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.addEscapedValue((CharSequence)v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.charSequenceEscaper(), var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl addObject(CharSequence name, Object value) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.addEscapedValue((CharSequence)v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl addObject(CharSequence name, Iterable<?> values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.addEscapedValue((CharSequence)v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl addObject(CharSequence name, Object ... values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.addEscapedValue((CharSequence)v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl set(CharSequence name, CharSequence ... values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this.set(v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.charSequenceEscaper(), var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl set(CharSequence name, Iterable<? extends CharSequence> values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this.set(v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.charSequenceEscaper(), var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl setObject(CharSequence name, Object value) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this.set(v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl setObject(CharSequence name, Object ... values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this.set(v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final CombinedHttpHeadersImpl setObject(CharSequence name, Iterable<?> values) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this.set(v0, CombinedHttpHeadersImpl.commaSeparate((CharSequence)v0, this.objectEscaper(), var2_2));
            return this;
        }

        private static boolean cannotBeCombined(CharSequence name) {
            CharSequence charSequence;
            return HttpHeaderNames.SET_COOKIE.contentEqualsIgnoreCase(charSequence);
        }

        /*
         * WARNING - void declaration
         */
        private CombinedHttpHeadersImpl addEscapedValue(CharSequence name, CharSequence escapedValue) {
            CharSequence currentValue = (CharSequence)this.get(name);
            if (currentValue == null || CombinedHttpHeadersImpl.cannotBeCombined(name)) {
                super.add((Object)name, (Object)escapedValue);
            } else {
                void var2_2;
                void var3_3;
                void var1_1;
                this.set(var1_1, CombinedHttpHeadersImpl.commaSeparateEscapedValues((CharSequence)var3_3, (CharSequence)var2_2));
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private static <T> CharSequence commaSeparate(CharSequence name, CsvValueEscaper<T> escaper, T ... values) {
            void var3_3;
            StringBuilder sb = new StringBuilder(values.length * 10);
            if (values.length > 0) {
                void var2_2;
                CharSequence charSequence;
                void var1_1;
                int end = values.length - 1;
                for (int i = 0; i < end; ++i) {
                    sb.append(escaper.escape(name, values[i])).append(',');
                }
                sb.append(var1_1.escape(charSequence, var2_2[end]));
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private static <T> CharSequence commaSeparate(CharSequence name, CsvValueEscaper<T> escaper, Iterable<? extends T> values) {
            void var3_3;
            StringBuilder sb = values instanceof Collection ? new StringBuilder(((Collection)values).size() * 10) : new StringBuilder();
            Iterator<T> iterator = values.iterator();
            if (iterator.hasNext()) {
                CharSequence charSequence;
                void var1_1;
                T next = iterator.next();
                while (iterator.hasNext()) {
                    sb.append(escaper.escape(name, next)).append(',');
                    next = iterator.next();
                }
                sb.append(var1_1.escape(charSequence, next));
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private static CharSequence commaSeparateEscapedValues(CharSequence currentValue, CharSequence value) {
            void var1_1;
            CharSequence charSequence;
            return new StringBuilder(currentValue.length() + 1 + value.length()).append(charSequence).append(',').append((CharSequence)var1_1);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(CharSequence var1, T var2);
        }
    }
}

