/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system.oshi;

import oshi.hardware.CentralProcessor;
import oshi.util.Util;

public class CpuTicks {
    long idle;
    long nice;
    long irq;
    long softIrq;
    long steal;
    long cSys;
    long user;
    long ioWait;

    /*
     * WARNING - void declaration
     */
    public CpuTicks(CentralProcessor processor, long waitingTime) {
        void var1_1;
        void var2_2;
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)var2_2);
        long[] ticks = processor.getSystemCpuLoadTicks();
        this.idle = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.IDLE);
        this.nice = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.NICE);
        this.irq = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.IRQ);
        this.softIrq = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.SOFTIRQ);
        this.steal = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.STEAL);
        this.cSys = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.SYSTEM);
        this.user = CpuTicks.tick(prevTicks, ticks, CentralProcessor.TickType.USER);
        this.ioWait = CpuTicks.tick(prevTicks, (long[])var1_1, CentralProcessor.TickType.IOWAIT);
    }

    public long getIdle() {
        return this.idle;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdle(long idle) {
        void var1_1;
        this.idle = var1_1;
    }

    public long getNice() {
        return this.nice;
    }

    /*
     * WARNING - void declaration
     */
    public void setNice(long nice) {
        void var1_1;
        this.nice = var1_1;
    }

    public long getIrq() {
        return this.irq;
    }

    /*
     * WARNING - void declaration
     */
    public void setIrq(long irq) {
        void var1_1;
        this.irq = var1_1;
    }

    public long getSoftIrq() {
        return this.softIrq;
    }

    /*
     * WARNING - void declaration
     */
    public void setSoftIrq(long softIrq) {
        void var1_1;
        this.softIrq = var1_1;
    }

    public long getSteal() {
        return this.steal;
    }

    /*
     * WARNING - void declaration
     */
    public void setSteal(long steal) {
        void var1_1;
        this.steal = var1_1;
    }

    public long getcSys() {
        return this.cSys;
    }

    /*
     * WARNING - void declaration
     */
    public void setcSys(long cSys) {
        void var1_1;
        this.cSys = var1_1;
    }

    public long getUser() {
        return this.user;
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(long user) {
        void var1_1;
        this.user = var1_1;
    }

    public long getIoWait() {
        return this.ioWait;
    }

    /*
     * WARNING - void declaration
     */
    public void setIoWait(long ioWait) {
        void var1_1;
        this.ioWait = var1_1;
    }

    public long totalCpu() {
        return Math.max(this.user + this.nice + this.cSys + this.idle + this.ioWait + this.irq + this.softIrq + this.steal, 0L);
    }

    public String toString() {
        return "CpuTicks{idle=" + this.idle + ", nice=" + this.nice + ", irq=" + this.irq + ", softIrq=" + this.softIrq + ", steal=" + this.steal + ", cSys=" + this.cSys + ", user=" + this.user + ", ioWait=" + this.ioWait + '}';
    }

    /*
     * WARNING - void declaration
     */
    private static long tick(long[] prevTicks, long[] ticks, CentralProcessor.TickType tickType) {
        void var2_2;
        long[] lArray;
        return ticks[tickType.getIndex()] - lArray[var2_2.getIndex()];
    }
}

