/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system.oshi;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.system.oshi.CpuTicks;
import java.text.DecimalFormat;
import oshi.hardware.CentralProcessor;

public class CpuInfo {
    private static final DecimalFormat LOAD_FORMAT = new DecimalFormat("#.00");
    private Integer cpuNum;
    private double toTal;
    private double sys;
    private double user;
    private double wait;
    private double free;
    private String cpuModel;
    private CpuTicks ticks;

    public CpuInfo() {
    }

    /*
     * WARNING - void declaration
     */
    public CpuInfo(CentralProcessor processor, long waitingTime) {
        void var2_2;
        void var1_1;
        this.init((CentralProcessor)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CpuInfo(Integer cpuNum, double toTal, double sys, double user, double wait, double free, String cpuModel) {
        void var2_2;
        void var1_1;
        this.cpuNum = var1_1;
        this.toTal = var2_2;
        this.sys = sys;
        this.user = user;
        this.wait = wait;
        this.free = free;
        this.cpuModel = cpuModel;
    }

    public Integer getCpuNum() {
        return this.cpuNum;
    }

    /*
     * WARNING - void declaration
     */
    public void setCpuNum(Integer cpuNum) {
        void var1_1;
        this.cpuNum = var1_1;
    }

    public double getToTal() {
        return this.toTal;
    }

    /*
     * WARNING - void declaration
     */
    public void setToTal(double toTal) {
        void var1_1;
        this.toTal = var1_1;
    }

    public double getSys() {
        return this.sys;
    }

    /*
     * WARNING - void declaration
     */
    public void setSys(double sys) {
        void var1_1;
        this.sys = var1_1;
    }

    public double getUser() {
        return this.user;
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(double user) {
        void var1_1;
        this.user = var1_1;
    }

    public double getWait() {
        return this.wait;
    }

    /*
     * WARNING - void declaration
     */
    public void setWait(double wait) {
        void var1_1;
        this.wait = var1_1;
    }

    public double getFree() {
        return this.free;
    }

    /*
     * WARNING - void declaration
     */
    public void setFree(double free) {
        void var1_1;
        this.free = var1_1;
    }

    public String getCpuModel() {
        return this.cpuModel;
    }

    /*
     * WARNING - void declaration
     */
    public void setCpuModel(String cpuModel) {
        void var1_1;
        this.cpuModel = var1_1;
    }

    public CpuTicks getTicks() {
        return this.ticks;
    }

    /*
     * WARNING - void declaration
     */
    public void setTicks(CpuTicks ticks) {
        void var1_1;
        this.ticks = var1_1;
    }

    public double getUsed() {
        return NumberUtil.sub(100.0f, this.free);
    }

    public String toString() {
        return "CpuInfo{CPU\u6838\u5fc3\u6570=" + this.cpuNum + ", CPU\u603b\u7684\u4f7f\u7528\u7387=" + this.toTal + ", CPU\u7cfb\u7edf\u4f7f\u7528\u7387=" + this.sys + ", CPU\u7528\u6237\u4f7f\u7528\u7387=" + this.user + ", CPU\u5f53\u524d\u7b49\u5f85\u7387=" + this.wait + ", CPU\u5f53\u524d\u7a7a\u95f2\u7387=" + this.free + ", CPU\u5229\u7528\u7387=" + this.getUsed() + ", CPU\u578b\u53f7\u4fe1\u606f='" + this.cpuModel + '\'' + '}';
    }

    /*
     * WARNING - void declaration
     */
    private void init(CentralProcessor processor, long waitingTime) {
        void var2_3;
        void var1_1;
        CpuTicks ticks;
        this.ticks = ticks = new CpuTicks(processor, waitingTime);
        this.cpuNum = processor.getLogicalProcessorCount();
        this.cpuModel = var1_1.toString();
        long totalCpu = ticks.totalCpu();
        this.toTal = totalCpu;
        this.sys = CpuInfo.formatDouble(ticks.cSys, totalCpu);
        this.user = CpuInfo.formatDouble(ticks.user, totalCpu);
        this.wait = CpuInfo.formatDouble(ticks.ioWait, totalCpu);
        this.free = CpuInfo.formatDouble(var2_3.idle, totalCpu);
    }

    /*
     * WARNING - void declaration
     */
    private static double formatDouble(long tick, long totalCpu) {
        void var2_1;
        long l;
        if (0L == totalCpu) {
            return 0.0;
        }
        return Double.parseDouble(LOAD_FORMAT.format(tick <= 0L ? 0.0 : 100.0 * (double)l / (double)var2_1));
    }
}

