/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import cn.hutool.system.HostInfo;
import cn.hutool.system.JavaInfo;
import cn.hutool.system.JavaRuntimeInfo;
import cn.hutool.system.JavaSpecInfo;
import cn.hutool.system.JvmInfo;
import cn.hutool.system.JvmSpecInfo;
import cn.hutool.system.OsInfo;
import cn.hutool.system.RuntimeInfo;
import cn.hutool.system.UserInfo;
import java.io.PrintWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;

public class SystemUtil
extends SystemPropsUtil {
    public static final String SPECIFICATION_NAME = "java.specification.name";
    public static final String VERSION = "java.version";
    public static final String SPECIFICATION_VERSION = "java.specification.version";
    public static final String VENDOR = "java.vendor";
    public static final String SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String VENDOR_URL = "java.vendor.url";
    public static final String HOME = "java.home";
    public static final String LIBRARY_PATH = "java.library.path";
    public static final String TMPDIR = "java.io.tmpdir";
    public static final String COMPILER = "java.compiler";
    public static final String EXT_DIRS = "java.ext.dirs";
    public static final String VM_NAME = "java.vm.name";
    public static final String VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String VM_VERSION = "java.vm.version";
    public static final String VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String VM_VENDOR = "java.vm.vendor";
    public static final String VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String CLASS_VERSION = "java.class.version";
    public static final String CLASS_PATH = "java.class.path";
    public static final String OS_NAME = "os.name";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_VERSION = "os.version";
    public static final String FILE_SEPARATOR = "file.separator";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";

    public static long getCurrentPID() {
        return Long.parseLong(SystemUtil.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static JvmSpecInfo getJvmSpecInfo() {
        return Singleton.get(JvmSpecInfo.class, new Object[0]);
    }

    public static JvmInfo getJvmInfo() {
        return Singleton.get(JvmInfo.class, new Object[0]);
    }

    public static JavaSpecInfo getJavaSpecInfo() {
        return Singleton.get(JavaSpecInfo.class, new Object[0]);
    }

    public static JavaInfo getJavaInfo() {
        return Singleton.get(JavaInfo.class, new Object[0]);
    }

    public static JavaRuntimeInfo getJavaRuntimeInfo() {
        return Singleton.get(JavaRuntimeInfo.class, new Object[0]);
    }

    public static OsInfo getOsInfo() {
        return Singleton.get(OsInfo.class, new Object[0]);
    }

    public static UserInfo getUserInfo() {
        return Singleton.get(UserInfo.class, new Object[0]);
    }

    public static HostInfo getHostInfo() {
        return Singleton.get(HostInfo.class, new Object[0]);
    }

    public static RuntimeInfo getRuntimeInfo() {
        return Singleton.get(RuntimeInfo.class, new Object[0]);
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    /*
     * WARNING - void declaration
     */
    public static int getTotalThreadCount() {
        void var0;
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (null != parentThread.getParent()) {
            parentThread = parentThread.getParent();
        }
        return var0.activeCount();
    }

    public static void dumpSystemInfo() {
        SystemUtil.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static void dumpSystemInfo(PrintWriter out) {
        PrintWriter printWriter;
        out.println("--------------");
        out.println(SystemUtil.getJvmSpecInfo());
        out.println("--------------");
        out.println(SystemUtil.getJvmInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaSpecInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(SystemUtil.getOsInfo());
        out.println("--------------");
        out.println(SystemUtil.getUserInfo());
        out.println("--------------");
        out.println(SystemUtil.getHostInfo());
        out.println("--------------");
        out.println(SystemUtil.getRuntimeInfo());
        out.println("--------------");
        printWriter.flush();
    }

    /*
     * WARNING - void declaration
     */
    protected static void append(StringBuilder builder, String caption, Object value) {
        void var2_2;
        void var1_1;
        builder.append((String)var1_1).append(StrUtil.nullToDefault(Convert.toStr(var2_2), "[n/a]")).append("\n");
    }
}

