/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.nio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.log.Log;
import cn.hutool.socket.nio.AcceptHandler;
import cn.hutool.socket.nio.ChannelHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioServer
implements Closeable {
    private static final Log log = Log.get();
    private static final AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    private Selector selector;
    private ServerSocketChannel serverSocketChannel;
    private ChannelHandler handler;

    /*
     * WARNING - void declaration
     */
    public NioServer(int port) {
        void var1_1;
        this.init(new InetSocketAddress((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public NioServer init(InetSocketAddress address) {
        void var1_1;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.bind(address);
            this.selector = Selector.open();
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (IOException e) {
            void var1_2;
            this.close();
            throw new IORuntimeException((Throwable)var1_2);
        }
        log.debug("Server listen on: [{}]...", var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public NioServer setChannelHandler(ChannelHandler handler) {
        void var1_1;
        this.handler = var1_1;
        return this;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void start() {
        this.listen();
    }

    /*
     * WARNING - void declaration
     */
    public void listen() {
        try {
            this.doListen();
            return;
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handle(SelectionKey key) {
        if (key.isAcceptable()) {
            ACCEPT_HANDLER.completed((ServerSocketChannel)key.channel(), this);
        }
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
                return;
            }
            catch (Exception e) {
                void var2_2;
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                log.error((Throwable)var2_2);
            }
        }
    }

    @Override
    public void close() {
        IoUtil.close(this.selector);
        IoUtil.close(this.serverSocketChannel);
    }
}

