/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.nio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.log.Log;
import cn.hutool.socket.SocketRuntimeException;
import cn.hutool.socket.nio.ChannelHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioClient
implements Closeable {
    private static final Log log = Log.get();
    private Selector selector;
    private SocketChannel channel;
    private ChannelHandler handler;

    /*
     * WARNING - void declaration
     */
    public NioClient(String host, int port) {
        void var2_2;
        void var1_1;
        this.init(new InetSocketAddress((String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public NioClient(InetSocketAddress address) {
        void var1_1;
        this.init((InetSocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public NioClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(address);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            while (!this.channel.finishConnect()) {
            }
        }
        catch (IOException e) {
            void var1_2;
            this.close();
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public NioClient setChannelHandler(ChannelHandler handler) {
        void var1_1;
        this.handler = var1_1;
        return this;
    }

    public void listen() {
        ThreadUtil.execute(() -> {
            try {
                this.doListen();
                return;
            }
            catch (IOException e) {
                void var1_1;
                log.error("Listen failed", var1_1);
                return;
            }
        });
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handle(SelectionKey key) {
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
                return;
            }
            catch (Exception e) {
                void var1_2;
                throw new SocketRuntimeException((Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public NioClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        IoUtil.close(this.selector);
        IoUtil.close(this.channel);
    }
}

