/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.aio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.socket.SocketConfig;
import cn.hutool.socket.SocketUtil;
import cn.hutool.socket.aio.IoAction;
import cn.hutool.socket.aio.ReadHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AioSession
implements Closeable {
    private static final ReadHandler READ_HANDLER = new ReadHandler();
    private final AsynchronousSocketChannel channel;
    private final IoAction<ByteBuffer> ioAction;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final long readTimeout;
    private final long writeTimeout;

    /*
     * WARNING - void declaration
     */
    public AioSession(AsynchronousSocketChannel channel, IoAction<ByteBuffer> ioAction, SocketConfig config) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.channel = var1_1;
        this.ioAction = var2_2;
        this.readBuffer = ByteBuffer.allocate(config.getReadBufferSize());
        this.writeBuffer = ByteBuffer.allocate(config.getWriteBufferSize());
        this.readTimeout = config.getReadTimeout();
        this.writeTimeout = var3_3.getWriteTimeout();
    }

    public AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getReadBuffer() {
        return this.readBuffer;
    }

    public ByteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    public SocketAddress getRemoteAddress() {
        return SocketUtil.getRemoteAddress(this.channel);
    }

    public AioSession read() {
        return this.read(READ_HANDLER);
    }

    /*
     * WARNING - void declaration
     */
    public AioSession read(CompletionHandler<Integer, AioSession> handler) {
        if (this.isOpen()) {
            void var1_1;
            this.readBuffer.clear();
            this.channel.read(this.readBuffer, Math.max(this.readTimeout, 0L), TimeUnit.MILLISECONDS, this, var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AioSession writeAndClose(ByteBuffer data) {
        void var1_1;
        this.write((ByteBuffer)var1_1);
        return this.closeOut();
    }

    /*
     * WARNING - void declaration
     */
    public Future<Integer> write(ByteBuffer data) {
        void var1_1;
        return this.channel.write((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AioSession write(ByteBuffer data, CompletionHandler<Integer, AioSession> handler) {
        void var2_2;
        void var1_1;
        this.channel.write((ByteBuffer)var1_1, Math.max(this.writeTimeout, 0L), TimeUnit.MILLISECONDS, this, var2_2);
        return this;
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    /*
     * WARNING - void declaration
     */
    public AioSession closeIn() {
        if (this.channel != null) {
            try {
                this.channel.shutdownInput();
            }
            catch (IOException e) {
                void var1_1;
                throw new IORuntimeException((Throwable)var1_1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AioSession closeOut() {
        if (this.channel != null) {
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException e) {
                void var1_1;
                throw new IORuntimeException((Throwable)var1_1);
            }
        }
        return this;
    }

    @Override
    public void close() {
        IoUtil.close(this.channel);
        this.readBuffer = null;
        this.writeBuffer = null;
    }

    protected void callbackRead() {
        this.readBuffer.flip();
        AioSession aioSession = this;
        this.ioAction.doAction(aioSession, aioSession.readBuffer);
    }
}

