/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.aio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.socket.SocketConfig;
import cn.hutool.socket.aio.AcceptHandler;
import cn.hutool.socket.aio.IoAction;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;

public class AioServer
implements Closeable {
    private static final Log log = LogFactory.get();
    private static final AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel channel;
    protected IoAction<ByteBuffer> ioAction;
    protected final SocketConfig config;

    /*
     * WARNING - void declaration
     */
    public AioServer(int port) {
        this(new InetSocketAddress((int)var1_1), new SocketConfig());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AioServer(InetSocketAddress address, SocketConfig config) {
        void var1_1;
        void var2_2;
        this.config = var2_2;
        this.init((InetSocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AioServer init(InetSocketAddress address) {
        try {
            this.group = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadPoolSize(), ThreadFactoryBuilder.create().setNamePrefix("Hutool-socket-").build());
            this.channel = AsynchronousServerSocketChannel.open(this.group).bind(address);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void start(boolean sync) {
        void var1_1;
        this.doStart((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> AioServer setOption(SocketOption<T> name, T value) throws IOException {
        void var2_2;
        void var1_1;
        this.channel.setOption((SocketOption)var1_1, (Object)var2_2);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    /*
     * WARNING - void declaration
     */
    public AioServer setIoAction(IoAction<ByteBuffer> ioAction) {
        void var1_1;
        this.ioAction = var1_1;
        return this;
    }

    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public AioServer accept() {
        this.channel.accept(this, ACCEPT_HANDLER);
        return this;
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void close() {
        IoUtil.close(this.channel);
        if (this.group != null && !this.group.isShutdown()) {
            try {
                this.group.shutdownNow();
            }
            catch (IOException iOException) {}
        }
        AioServer aioServer = this;
        synchronized (aioServer) {
            this.notify();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doStart(boolean sync) {
        void var1_1;
        log.debug("Aio Server started, waiting for accept.", new Object[0]);
        this.accept();
        if (var1_1 != false) {
            ThreadUtil.sync(this);
        }
    }
}

