/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.profile;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

public class Profile
implements Serializable {
    private static final long serialVersionUID = -4189955219454008744L;
    public static final String DEFAULT_PROFILE = "default";
    private String profile;
    private Charset charset;
    private boolean useVar;
    private final Map<String, Setting> settingMap = new SafeConcurrentHashMap<String, Setting>();

    public Profile() {
        this(DEFAULT_PROFILE);
    }

    /*
     * WARNING - void declaration
     */
    public Profile(String profile) {
        this((String)var1_1, Setting.DEFAULT_CHARSET, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Profile(String profile, Charset charset, boolean useVar) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.profile = var1_1;
        this.charset = var2_2;
        this.useVar = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Setting getSetting(String name) {
        void var2_2;
        String nameForProfile = this.fixNameForProfile(name);
        Setting setting = this.settingMap.get(nameForProfile);
        if (setting == null) {
            void var1_1;
            setting = new Setting(nameForProfile, this.charset, this.useVar);
            this.settingMap.put((String)var1_1, setting);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Profile setProfile(String profile) {
        void var1_1;
        this.profile = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Profile setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Profile setUseVar(boolean useVar) {
        void var1_1;
        this.useVar = var1_1;
        return this;
    }

    public Profile clear() {
        this.settingMap.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String fixNameForProfile(String name) {
        void var1_1;
        void var2_2;
        Assert.notBlank(name, "Setting name must be not blank !", new Object[0]);
        String actralProfile = StrUtil.nullToEmpty(this.profile);
        if (!name.contains(".")) {
            return StrUtil.format("{}/{}.setting", actralProfile, name);
        }
        return StrUtil.format("{}/{}", var2_2, var1_1);
    }
}

