/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.dialect;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.BasicTypeGetter;
import cn.hutool.core.getter.OptBasicTypeGetter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.WatchUtil;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.StaticLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class Props
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = CharsetUtil.CHARSET_ISO_8859_1;

    public static Props create() {
        return new Props();
    }

    public static Props getProp(String resource) {
        String string;
        return new Props(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Props getProp(String resource, String charsetName) {
        void var1_1;
        String string;
        return new Props(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Props getProp(String resource, Charset charset) {
        void var1_1;
        String string;
        return new Props(string, (Charset)var1_1);
    }

    public Props() {
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path) {
        this((String)var1_1, CharsetUtil.CHARSET_ISO_8859_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path, String charsetName) {
        this((String)var1_1, CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path, Charset charset) {
        void var1_1;
        Assert.notBlank(path, "Blank properties file path !", new Object[0]);
        if (charset != null) {
            void var2_2;
            this.charset = var2_2;
        }
        this.load(ResourceUtil.getResourceObj((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Props(File propertiesFile) {
        this((File)var1_1, StandardCharsets.ISO_8859_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(File propertiesFile, String charsetName) {
        this((File)var1_1, Charset.forName((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(File propertiesFile, Charset charset) {
        void var1_1;
        void var2_2;
        Assert.notNull(propertiesFile, "Null properties file!", new Object[0]);
        this.charset = var2_2;
        this.load(new FileResource((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path, Class<?> clazz) {
        this((String)var1_1, (Class<?>)var2_2, "ISO-8859-1");
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path, Class<?> clazz, String charsetName) {
        this((String)var1_1, (Class<?>)var2_2, CharsetUtil.charset((String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(String path, Class<?> clazz, Charset charset) {
        void var2_2;
        void var1_1;
        Assert.notBlank(path, "Blank properties file path !", new Object[0]);
        if (charset != null) {
            void var3_3;
            this.charset = var3_3;
        }
        this.load(new ClassPathResource((String)var1_1, (Class<?>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Props(URL propertiesUrl) {
        this((URL)var1_1, StandardCharsets.ISO_8859_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(URL propertiesUrl, String charsetName) {
        this((URL)var1_1, CharsetUtil.charset((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Props(URL propertiesUrl, Charset charset) {
        void var1_1;
        Assert.notNull(propertiesUrl, "Null properties URL !", new Object[0]);
        if (charset != null) {
            void var2_2;
            this.charset = var2_2;
        }
        this.load((URL)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Props(Properties properties) {
        if (MapUtil.isNotEmpty(properties)) {
            void var1_1;
            this.putAll((Map<?, ?>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void load(URL url) {
        void var1_1;
        this.load(new UrlResource((URL)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void load(Resource resource) {
        Assert.notNull(resource, "Props resource must be not null!", new Object[0]);
        this.resource = resource;
        try {
            BufferedReader reader2;
            block12: {
                block11: {
                    reader2 = resource.getReader(this.charset);
                    Throwable throwable = null;
                    try {
                        super.load(reader2);
                        if (reader2 == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (reader2 != null) {
                                if (throwable != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable reader2) {
                                        throwable.addSuppressed(reader2);
                                    }
                                } else {
                                    reader2.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    break block12;
                }
                return;
            }
            reader2.close();
        }
        catch (IOException e) {
            void var1_3;
            throw new IORuntimeException((Throwable)var1_3);
        }
    }

    public final void load() {
        Props props = this;
        props.load(props.resource);
    }

    public final void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull(this.resource, "Properties resource must be not null!", new Object[0]);
            if (this.watchMonitor != null) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(this){
                final /* synthetic */ Props this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    this.this$0.load();
                }
            });
            this.watchMonitor.start();
            return;
        }
        IoUtil.close(this.watchMonitor);
        this.watchMonitor = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getObj(String key, Object defaultValue) {
        void var2_2;
        void var1_1;
        return this.getStr((String)var1_1, defaultValue == null ? null : var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getObj(String key) {
        void var1_1;
        return this.getObj((String)var1_1, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getStr(String key, String defaultValue) {
        void var2_2;
        void var1_1;
        return super.getProperty((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getStr(String key) {
        void var1_1;
        return super.getProperty((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Integer getInt(String key, Integer defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toInt(this.getStr((String)var1_1), (Integer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Integer getInt(String key) {
        void var1_1;
        return this.getInt((String)var1_1, (Integer)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Boolean getBool(String key, Boolean defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toBool(this.getStr((String)var1_1), (Boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Boolean getBool(String key) {
        void var1_1;
        return this.getBool((String)var1_1, (Boolean)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long getLong(String key, Long defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toLong(this.getStr((String)var1_1), (Long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long getLong(String key) {
        void var1_1;
        return this.getLong((String)var1_1, (Long)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Character getChar(String key, Character defaultValue) {
        void var1_1;
        String value = this.getStr(key);
        if (StrUtil.isBlank(value)) {
            void var2_2;
            return var2_2;
        }
        return Character.valueOf(var1_1.charAt(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Character getChar(String key) {
        void var1_1;
        return this.getChar((String)var1_1, (Character)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Float getFloat(String key) {
        void var1_1;
        return this.getFloat((String)var1_1, (Float)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Float getFloat(String key, Float defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toFloat(this.getStr((String)var1_1), (Float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        void var2_2;
        void var1_1;
        return Convert.toDouble(this.getStr((String)var1_1), (Double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double getDouble(String key) throws NumberFormatException {
        void var1_1;
        return this.getDouble((String)var1_1, (Double)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Short getShort(String key, Short defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toShort(this.getStr((String)var1_1), (Short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Short getShort(String key) {
        void var1_1;
        return this.getShort((String)var1_1, (Short)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Byte getByte(String key, Byte defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toByte(this.getStr((String)var1_1), (Byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Byte getByte(String key) {
        void var1_1;
        return this.getByte((String)var1_1, (Byte)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            void var1_1;
            return new BigDecimal((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BigDecimal getBigDecimal(String key) {
        void var1_1;
        return this.getBigDecimal((String)var1_1, (BigDecimal)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            void var1_1;
            return new BigInteger((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BigInteger getBigInteger(String key) {
        void var1_1;
        return this.getBigInteger((String)var1_1, (BigInteger)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        void var3_3;
        void var2_2;
        return Convert.toEnum(clazz, this.getStr((String)var2_2), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        void var2_2;
        void var1_1;
        return this.getEnum((Class<E>)var1_1, (String)var2_2, (E)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date getDate(String key, Date defaultValue) {
        void var2_2;
        void var1_1;
        return Convert.toDate(this.getStr((String)var1_1), (Date)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date getDate(String key) {
        void var1_1;
        return this.getDate((String)var1_1, (Date)null);
    }

    /*
     * WARNING - void declaration
     */
    public final String getAndRemoveStr(String ... keys) {
        Object object;
        void var1_1;
        Object value = null;
        for (void key : var1_1) {
            if ((object = this.remove(object)) != null) break;
        }
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    public final Properties toProperties() {
        void var1_1;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T toBean(Class<T> beanClass) {
        void var1_1;
        return this.toBean((Class<T>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T toBean(Class<T> beanClass, String prefix) {
        void var2_2;
        void var1_1;
        T bean = ReflectUtil.newInstanceIfPossible(beanClass);
        return this.fillBean(var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T fillBean(T bean, String prefix) {
        void var1_1;
        prefix = StrUtil.nullToEmpty(StrUtil.addSuffixIfNot(prefix, "."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key, prefix)) continue;
            try {
                BeanUtil.setProperty(bean, StrUtil.subSuf(key, prefix.length()), entry.getValue());
            }
            catch (Exception e) {
                void var3_4;
                StaticLog.debug("Ignore property: [{}],because of: {}", var3_4, e);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProperty(String key, Object value) {
        void var2_2;
        void var1_1;
        super.setProperty((String)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, this.charset, false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                void var1_1;
                void var3_4;
                throw new IORuntimeException((Throwable)var3_4, "Store properties to [{}] error!", var1_1);
            }
            catch (Throwable throwable) {
                void var2_3;
                IoUtil.close((Closeable)var2_3);
                throw throwable;
            }
        }
        IoUtil.close(writer);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public final void store(String path, Class<?> clazz) {
        void var2_2;
        void var1_1;
        this.store(FileUtil.getAbsolutePath((String)var1_1, var2_2));
    }
}

