/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import cn.hutool.log.Log;
import cn.hutool.setting.GroupedMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private final Charset charset;
    private final boolean isUseVariable;
    private final GroupedMap groupedMap;

    /*
     * WARNING - void declaration
     */
    public SettingLoader(GroupedMap groupedMap) {
        this((GroupedMap)var1_1, CharsetUtil.CHARSET_UTF_8, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SettingLoader(GroupedMap groupedMap, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.groupedMap = var1_1;
        this.charset = var2_2;
        this.isUseVariable = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean load(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", resource);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            try {
                void var1_2;
                log.error((Throwable)var1_2, "Load setting error!", new Object[0]);
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
            IoUtil.close(settingStream);
            return false;
        }
        IoUtil.close(settingStream);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoUtil.getReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                void var3_4;
                if (StrUtil.isBlank(line = StrUtil.trim(line)) || StrUtil.startWith((CharSequence)line, '#')) continue;
                if (StrUtil.isSurround((CharSequence)line, '[', ']')) {
                    group = StrUtil.trim(line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = StrUtil.splitToArray(line, this.assignFlag, 2);
                if (keyValue.length < 2) continue;
                String value = StrUtil.trim(keyValue[1]);
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, StrUtil.trim((CharSequence)var3_4[0]), value);
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(reader);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setVarRegex(String regex) {
        void var1_1;
        this.varRegex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAssignFlag(char assignFlag) {
        void var1_1;
        this.assignFlag = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void store(String absolutePath) {
        void var1_1;
        this.store(FileUtil.touch((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void store(File file) {
        Assert.notNull(file, "File to store must be not null !", new Object[0]);
        log.debug("Store Setting to [{}]...", file.getAbsolutePath());
        PrintWriter writer = null;
        try {
            void var1_1;
            writer = FileUtil.getPrintWriter((File)var1_1, this.charset, false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(writer);
    }

    private synchronized void store(PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            Iterator iterator;
            writer.println(StrUtil.format("{}{}{}", Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')));
            for (Map.Entry entry : ((LinkedHashMap)iterator.getValue()).entrySet()) {
                writer.println(StrUtil.format("{} {} {}", entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String replaceVar(String group, String value) {
        void var2_2;
        Set set = ReUtil.findAll(this.varRegex, (CharSequence)value, 0, new HashSet());
        for (String var : set) {
            List<String> groupAndKey;
            String key = ReUtil.get(this.varRegex, (CharSequence)var, 1);
            if (!StrUtil.isNotBlank(key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (varValue == null && (groupAndKey = StrUtil.split(key, '.', 2)).size() > 1) {
                varValue = this.groupedMap.get(groupAndKey.get(0), groupAndKey.get(1));
            }
            if (varValue == null) {
                varValue = SystemPropsUtil.get((String)((Object)set));
            }
            if (varValue == null) continue;
            value = value.replace(var, varValue);
        }
        return var2_2;
    }
}

