/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.WatchUtil;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.StaticLog;
import cn.hutool.setting.AbsSetting;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.SettingLoader;
import cn.hutool.setting.dialect.Props;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class Setting
extends AbsSetting
implements Map<String, String> {
    private static final long serialVersionUID = 3618305164959883393L;
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    public static final String EXT_NAME = "setting";
    private final GroupedMap groupedMap = new GroupedMap();
    protected Charset charset;
    protected boolean isUseVariable;
    protected Resource resource;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public static Setting create() {
        return new Setting();
    }

    public Setting() {
        this.charset = DEFAULT_CHARSET;
    }

    /*
     * WARNING - void declaration
     */
    public Setting(String path) {
        this((String)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Setting(String path, boolean isUseVariable) {
        this((String)var1_1, DEFAULT_CHARSET, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Setting(String path, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notBlank(path, "Blank setting path !", new Object[0]);
        this.init(ResourceUtil.getResourceObj((String)var1_1), (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Setting(File configFile, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(configFile, "Null setting file define!", new Object[0]);
        this.init(new FileResource((File)var1_1), (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Setting(String path, Class<?> clazz, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notBlank(path, "Blank setting path !", new Object[0]);
        this.init(new ClassPathResource((String)var1_1, (Class<?>)var2_2), (Charset)var3_3, isUseVariable);
    }

    /*
     * WARNING - void declaration
     */
    public Setting(URL url, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(url, "Null setting url define!", new Object[0]);
        this.init(new UrlResource((URL)var1_1), (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Setting(Resource resource, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((Resource)var1_1, (Charset)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean init(Resource resource, Charset charset, boolean isUseVariable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(resource, "Setting resource must be not null!", new Object[0]);
        this.resource = var1_1;
        this.charset = var2_2;
        this.isUseVariable = var3_3;
        return this.load();
    }

    public synchronized boolean load() {
        if (this.settingLoader == null) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(this.resource);
    }

    /*
     * WARNING - void declaration
     */
    public void autoLoad(boolean autoReload) {
        void var1_1;
        this.autoLoad((boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void autoLoad(boolean autoReload, Consumer<Boolean> callback) {
        if (autoReload) {
            void var2_2;
            Assert.notNull(this.resource, "Setting resource must be not null !", new Object[0]);
            if (this.watchMonitor != null) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(this, (Consumer)var2_2){
                final /* synthetic */ Consumer val$callback;
                final /* synthetic */ Setting this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$callback = consumer;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    boolean success = this.this$0.load();
                    if (this.val$callback != null) {
                        void var1_2;
                        this.val$callback.accept((boolean)var1_2);
                    }
                }
            });
            this.watchMonitor.start();
            StaticLog.debug("Auto load for [{}] listenning...", this.resource.getUrl());
            return;
        }
        IoUtil.close(this.watchMonitor);
        this.watchMonitor = null;
    }

    public URL getSettingUrl() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getUrl();
    }

    /*
     * WARNING - void declaration
     */
    public String getSettingPath() {
        void var1_1;
        URL settingUrl = this.getSettingUrl();
        if (settingUrl == null) {
            return null;
        }
        return var1_1.getPath();
    }

    @Override
    public int size() {
        return this.groupedMap.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getByGroup(String key, String group) {
        void var1_1;
        void var2_2;
        return this.groupedMap.get((String)var2_2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object getAndRemove(String ... keys) {
        String string;
        void var1_1;
        Object value = null;
        for (void key : var1_1) {
            if ((string = this.remove(string)) != null) break;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getAndRemoveStr(String ... keys) {
        String string;
        void var1_1;
        Object value = null;
        for (void key : var1_1) {
            if ((string = this.remove(string)) != null) break;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getMap(String group) {
        Object map = this.groupedMap.get(group);
        if (map != null) {
            void var1_1;
            return var1_1;
        }
        return new LinkedHashMap<String, String>(0);
    }

    /*
     * WARNING - void declaration
     */
    public Setting getSetting(String group) {
        void var2_2;
        void var1_1;
        Setting setting = new Setting();
        setting.putAll((Map<? extends String, ? extends String>)this.getMap((String)var1_1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProperties(String group) {
        void var2_2;
        void var1_1;
        Properties properties = new Properties();
        properties.putAll(this.getMap((String)var1_1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Props getProps(String group) {
        void var2_2;
        void var1_1;
        Props props = new Props();
        props.putAll(this.getMap((String)var1_1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void store() {
        void var1_1;
        URL resourceUrl = this.getSettingUrl();
        Assert.notNull(resourceUrl, "Setting path must be not null !", new Object[0]);
        this.store(FileUtil.file((URL)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void store(String absolutePath) {
        void var1_1;
        this.store(FileUtil.touch((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void store(File file) {
        void var1_1;
        if (this.settingLoader == null) {
            this.settingLoader = new SettingLoader(this.groupedMap, this.charset, this.isUseVariable);
        }
        this.settingLoader.store((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Properties toProperties() {
        void var1_1;
        Properties properties = new Properties();
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            String group = groupEntry.getKey();
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                properties.setProperty(StrUtil.isEmpty(group) ? entry.getKey() : group + '.' + entry.getKey(), entry.getValue());
            }
        }
        return var1_1;
    }

    public GroupedMap getGroupedMap() {
        return this.groupedMap;
    }

    public List<String> getGroups() {
        return CollUtil.newArrayList(this.groupedMap.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public Setting setVarRegex(String regex) {
        void var1_1;
        if (this.settingLoader == null) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Setting setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty(String group) {
        void var1_1;
        return this.groupedMap.isEmpty((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(String group, String key) {
        void var2_2;
        void var1_1;
        return this.groupedMap.containsKey((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsValue(String group, String value) {
        void var2_2;
        void var1_1;
        return this.groupedMap.containsValue((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String get(String group, String key) {
        void var2_2;
        void var1_1;
        return this.groupedMap.get((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String putByGroup(String key, String group, String value) {
        void var3_3;
        void var1_1;
        void var2_2;
        return this.groupedMap.put((String)var2_2, (String)var1_1, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String remove(String group, Object key) {
        void var2_2;
        void var1_1;
        return this.groupedMap.remove((String)var1_1, Convert.toStr(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Setting putAll(String group, Map<? extends String, ? extends String> m) {
        void var2_2;
        void var1_1;
        this.groupedMap.putAll((String)var1_1, (Map<? extends String, ? extends String>)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Setting addSetting(Setting setting) {
        for (Map.Entry<String, LinkedHashMap<String, String>> e : setting.getGroupedMap().entrySet()) {
            void var2_2;
            this.putAll(e.getKey(), (Map)var2_2.getValue());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Setting clear(String group) {
        void var1_1;
        this.groupedMap.clear((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> keySet(String group) {
        void var1_1;
        return this.groupedMap.keySet((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<String> values(String group) {
        void var1_1;
        return this.groupedMap.values((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Map.Entry<String, String>> entrySet(String group) {
        void var1_1;
        return this.groupedMap.entrySet((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Setting set(String key, String value) {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Setting setByGroup(String key, String group, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.putByGroup((String)var1_1, (String)var2_2, (String)var3_3);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.groupedMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.groupedMap.containsKey("", Convert.toStr(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.groupedMap.containsValue("", Convert.toStr(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(Object key) {
        void var1_1;
        return this.groupedMap.get("", Convert.toStr(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String put(String key, String value) {
        void var2_2;
        void var1_1;
        return this.groupedMap.put("", (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String remove(Object key) {
        void var1_1;
        return this.groupedMap.remove("", Convert.toStr(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        void var1_1;
        this.groupedMap.putAll("", (Map<? extends String, ? extends String>)var1_1);
    }

    @Override
    public void clear() {
        this.groupedMap.clear("");
    }

    @Override
    public Set<String> keySet() {
        return this.groupedMap.keySet("");
    }

    @Override
    public Collection<String> values() {
        return this.groupedMap.values("");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.groupedMap.entrySet("");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + (this.charset == null ? 0 : this.charset.hashCode());
        result = result * 31 + this.groupedMap.hashCode();
        result = result * 31 + (this.isUseVariable ? 1231 : 1237);
        var1_1 = var1_1 * 31 + (this.resource == null ? 0 : this.resource.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (this.charset == null ? other.charset != null : false == this.charset.equals(other.charset)) {
            return false;
        }
        if (!this.groupedMap.equals(other.groupedMap)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        if (this.resource == null) {
            return other.resource == null;
        }
        return this.resource.equals(var1_1.resource);
    }

    public String toString() {
        return this.groupedMap.toString();
    }
}

