/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class GroupedSet
extends HashMap<String, LinkedHashSet<String>> {
    private static final long serialVersionUID = -8430706353275835496L;
    private static final String COMMENT_FLAG_PRE = "#";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private Charset charset;
    private URL groupedSetUrl;

    /*
     * WARNING - void declaration
     */
    public GroupedSet(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GroupedSet(String pathBaseClassLoader, Charset charset) {
        void var2_2;
        void var3_3;
        URL url;
        if (pathBaseClassLoader == null) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            void var1_1;
            throw new RuntimeException(StrUtil.format("Can not find GroupSet file: [{}]", var1_1));
        }
        this.init((URL)var3_3, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public GroupedSet(File configFile, Charset charset) {
        void var2_2;
        void var1_1;
        if (configFile == null) {
            throw new RuntimeException("Null GroupSet file!");
        }
        URL url = URLUtil.getURL(configFile);
        this.init((URL)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public GroupedSet(String path, Class<?> clazz, Charset charset) {
        void var3_3;
        void var2_2;
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            void var1_1;
            throw new RuntimeException(StrUtil.format("Can not find GroupSet file: [{}]", var1_1));
        }
        this.init((URL)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public GroupedSet(URL url, Charset charset) {
        void var2_2;
        void var1_1;
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init((URL)var1_1, (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public GroupedSet(String pathBaseClassLoader) {
        this((String)var1_1, CharsetUtil.CHARSET_UTF_8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean init(URL groupedSetUrl, Charset charset) {
        void var1_1;
        void var2_2;
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url or charset define!");
        }
        this.charset = var2_2;
        this.groupedSetUrl = groupedSetUrl;
        return this.load((URL)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean load(URL groupedSetUrl) {
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url define!");
        }
        InputStream settingStream = null;
        try {
            void var1_1;
            settingStream = var1_1.openStream();
            this.load(settingStream);
        }
        catch (IOException iOException) {
            IoUtil.close(settingStream);
            return false;
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(settingStream);
        return true;
    }

    public void reload() {
        GroupedSet groupedSet = this;
        groupedSet.load(groupedSet.groupedSetUrl);
    }

    /*
     * WARNING - void declaration
     */
    public boolean load(InputStream settingStream) throws IOException {
        super.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoUtil.getReader(settingStream, this.charset);
            LinkedHashSet<void> valueSet = null;
            while ((line = reader.readLine()) != null) {
                void var1_1;
                if (StrUtil.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.startsWith("\\#")) {
                    line = line.substring(1);
                }
                if (line.charAt(0) == GROUP_SURROUND[0]) {
                    String string = line;
                    if (string.charAt(string.length() - 1) == GROUP_SURROUND[1]) {
                        String group = line.substring(1, line.length() - 1).trim();
                        valueSet = (LinkedHashSet<void>)super.get(group);
                        if (valueSet == null) {
                            valueSet = new LinkedHashSet<void>();
                        }
                        super.put(var1_1, valueSet);
                        continue;
                    }
                }
                if (valueSet == null) {
                    valueSet = new LinkedHashSet<void>();
                    super.put("", valueSet);
                }
                valueSet.add(var1_1);
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(reader);
        return true;
    }

    public String getPath() {
        return this.groupedSetUrl.getPath();
    }

    public Set<String> getGroups() {
        return super.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet<String> getValues(String group) {
        void var1_1;
        if (group == null) {
            group = "";
        }
        return (LinkedHashSet)super.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(String group, String value, String ... otherValues) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (ArrayUtil.isNotEmpty(otherValues)) {
            ArrayList<String> valueList = ListUtil.toList(otherValues);
            valueList.add(value);
            return this.contains(group, valueList);
        }
        LinkedHashSet<String> valueSet = this.getValues((String)var1_1);
        if (CollectionUtil.isEmpty(valueSet)) {
            return false;
        }
        return var3_3.contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(String group, Collection<String> values) {
        void var2_2;
        void var1_1;
        LinkedHashSet<String> valueSet = this.getValues(group);
        if (CollectionUtil.isEmpty(values) || CollectionUtil.isEmpty(valueSet)) {
            return false;
        }
        return var1_1.containsAll((Collection<?>)var2_2);
    }
}

