/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GroupedMap
extends LinkedHashMap<String, LinkedHashMap<String, String>> {
    private static final long serialVersionUID = -7777365130776081931L;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    private int size = -1;

    /*
     * WARNING - void declaration
     */
    public String get(String group, String key) {
        this.readLock.lock();
        try {
            Object map = this.get(StrUtil.nullToEmpty(group));
            if (MapUtil.isNotEmpty(map)) {
                void var2_3;
                String string;
                string = (String)((LinkedHashMap)((Object)string)).get(var2_3);
                return string;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, String> get(Object key) {
        this.readLock.lock();
        try {
            LinkedHashMap linkedHashMap;
            linkedHashMap = (LinkedHashMap)super.get(linkedHashMap);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        this.writeLock.lock();
        try {
            if (this.size < 0) {
                this.size = 0;
                for (LinkedHashMap value : this.values()) {
                    void var2_3;
                    this.size += var2_3.size();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public String put(String group, String key, String value) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            void var3_4;
            void var2_3;
            String string;
            LinkedHashMap valueMap = this.computeIfAbsent(group, k -> new LinkedHashMap());
            this.size = -1;
            string = (String)((HashMap)((Object)string)).put(var2_3, var3_4);
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public GroupedMap putAll(String group, Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            void var3_3;
            this.put(group, entry.getKey(), (String)var3_3.getValue());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String remove(String group, String key) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                void var2_3;
                String string;
                string = (String)((HashMap)((Object)string)).remove(var2_3);
                return string;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                void var1_1;
                boolean bl = var1_1.isEmpty();
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(String group, String key) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                void var2_4;
                void var1_1;
                boolean bl = var1_1.containsKey(var2_4);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsValue(String group, String value) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                void var2_4;
                void var1_1;
                boolean bl = var1_1.containsValue(var2_4);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public GroupedMap clear(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                void var1_1;
                var1_1.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this;
    }

    @Override
    public Set<String> keySet() {
        this.readLock.lock();
        try {
            Set<String> set = super.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<String> keySet(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Set<String> set;
                set = ((LinkedHashMap)((Object)set)).keySet();
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    public Collection<String> values(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Collection<String> collection;
                collection = ((LinkedHashMap)((Object)collection)).values();
                return collection;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<Map.Entry<String, LinkedHashMap<String, String>>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<String, LinkedHashMap<String, String>>> set = super.entrySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Map.Entry<String, String>> entrySet(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Set<Map.Entry<String, String>> set;
                set = ((LinkedHashMap)((Object)set)).entrySet();
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

