/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.script;

import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.StrUtil;
import cn.hutool.script.JavaScriptEngine;
import cn.hutool.script.ScriptRuntimeException;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptUtil {
    private static final ScriptEngineManager MANAGER = new ScriptEngineManager();
    private static final WeakConcurrentMap<String, ScriptEngine> CACHE = new WeakConcurrentMap();

    public static ScriptEngine getScript(String nameOrExtOrMime) {
        String string;
        String string2 = string;
        return CACHE.computeIfAbsent(string2, () -> ScriptUtil.createScript(string2));
    }

    /*
     * WARNING - void declaration
     */
    public static ScriptEngine createScript(String nameOrExtOrMime) {
        void var1_1;
        ScriptEngine engine = MANAGER.getEngineByName(nameOrExtOrMime);
        if (engine == null) {
            engine = MANAGER.getEngineByExtension(nameOrExtOrMime);
        }
        if (engine == null) {
            engine = MANAGER.getEngineByMimeType(nameOrExtOrMime);
        }
        if (engine == null) {
            String string;
            throw new NullPointerException(StrUtil.format("Script for [{}] not support !", string));
        }
        return var1_1;
    }

    public static JavaScriptEngine getJavaScriptEngine() {
        return new JavaScriptEngine();
    }

    public static ScriptEngine getJsEngine() {
        return ScriptUtil.getScript("js");
    }

    public static ScriptEngine createJsEngine() {
        return ScriptUtil.createScript("js");
    }

    public static ScriptEngine getPythonEngine() {
        System.setProperty("python.import.site", "false");
        return ScriptUtil.getScript("python");
    }

    public static ScriptEngine createPythonEngine() {
        System.setProperty("python.import.site", "false");
        return ScriptUtil.createScript("python");
    }

    public static ScriptEngine getLuaEngine() {
        return ScriptUtil.getScript("lua");
    }

    public static ScriptEngine createLuaEngine() {
        return ScriptUtil.createScript("lua");
    }

    public static ScriptEngine getGroovyEngine() {
        return ScriptUtil.getScript("groovy");
    }

    public static ScriptEngine createGroovyEngine() {
        return ScriptUtil.createScript("groovy");
    }

    /*
     * WARNING - void declaration
     */
    public static Invocable evalInvocable(String script) throws ScriptRuntimeException {
        Object eval;
        ScriptEngine jsEngine = ScriptUtil.getJsEngine();
        try {
            eval = jsEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
        if (eval instanceof Invocable) {
            Object object;
            return (Invocable)object;
        }
        if (jsEngine instanceof Invocable) {
            void var1_2;
            return (Invocable)var1_2;
        }
        throw new ScriptRuntimeException("Script is not invocable !");
    }

    /*
     * WARNING - void declaration
     */
    public static Object eval(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.getJsEngine().eval(script);
        }
        catch (ScriptException e) {
            void var0_1;
            throw new ScriptRuntimeException((ScriptException)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object eval(String script, ScriptContext context) throws ScriptRuntimeException {
        try {
            void var1_2;
            return ScriptUtil.getJsEngine().eval(script, (ScriptContext)var1_2);
        }
        catch (ScriptException e) {
            void var0_1;
            throw new ScriptRuntimeException((ScriptException)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object eval(String script, Bindings bindings) throws ScriptRuntimeException {
        try {
            void var1_2;
            return ScriptUtil.getJsEngine().eval(script, (Bindings)var1_2);
        }
        catch (ScriptException e) {
            void var0_1;
            throw new ScriptRuntimeException((ScriptException)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object invoke(String script, String func, Object ... args) {
        Invocable eval = ScriptUtil.evalInvocable(script);
        try {
            void var2_3;
            void var1_2;
            return eval.invokeFunction((String)var1_2, (Object[])var2_3);
        }
        catch (NoSuchMethodException | ScriptException e) {
            void var0_1;
            throw new ScriptRuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CompiledScript compile(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(ScriptUtil.getJsEngine(), script);
        }
        catch (ScriptException e) {
            void var0_1;
            throw new ScriptRuntimeException((ScriptException)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CompiledScript compile(ScriptEngine engine, String script) throws ScriptException {
        if (engine instanceof Compilable) {
            void var1_1;
            Compilable compilable;
            compilable = compilable;
            return compilable.compile((String)var1_1);
        }
        return null;
    }
}

