/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.word;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.poi.exceptions.POIException;
import cn.hutool.poi.word.DocUtil;
import cn.hutool.poi.word.PicType;
import cn.hutool.poi.word.TableUtil;
import java.awt.Font;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class Word07Writer
implements Closeable {
    private final XWPFDocument doc;
    protected File destFile;
    protected boolean isClosed;

    public Word07Writer() {
        this(new XWPFDocument());
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer(File destFile) {
        this(DocUtil.create(destFile), (File)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer(XWPFDocument doc) {
        this((XWPFDocument)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer(XWPFDocument doc, File destFile) {
        void var2_2;
        void var1_1;
        this.doc = var1_1;
        this.destFile = var2_2;
    }

    public XWPFDocument getDoc() {
        return this.doc;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer setDestFile(File destFile) {
        void var1_1;
        this.destFile = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer addText(Font font, String ... texts) {
        void var2_2;
        void var1_1;
        return this.addText(null, (Font)var1_1, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer addText(ParagraphAlignment align, Font font, String ... texts) {
        XWPFParagraph p = this.doc.createParagraph();
        if (align != null) {
            p.setAlignment(align);
        }
        if (ArrayUtil.isNotEmpty(texts)) {
            void var3_3;
            for (void text : var3_3) {
                void var1_1;
                XWPFRun run = p.createRun();
                run.setText((String)text);
                if (font == null) continue;
                run.setFontFamily(font.getFamily());
                run.setFontSize(font.getSize());
                run.setBold(font.isBold());
                var1_1.setItalic(font.isItalic());
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer addTable(Iterable<?> data) {
        void var1_1;
        TableUtil.createTable(this.doc, var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer addPicture(File picFile, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        PicType picType;
        String fileName = picFile.getName();
        String extName = FileUtil.extName(fileName).toUpperCase();
        try {
            picType = PicType.valueOf(extName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            picType = PicType.JPEG;
        }
        return this.addPicture(FileUtil.getInputStream((File)var1_1), picType, fileName, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer addPicture(InputStream in, PicType picType, String fileName, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addPicture((InputStream)var1_1, (PicType)var2_2, (String)var3_3, width, height, ParagraphAlignment.CENTER);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Word07Writer addPicture(InputStream in, PicType picType, String fileName, int width, int height, ParagraphAlignment align) {
        XWPFParagraph paragraph = this.doc.createParagraph();
        paragraph.setAlignment(align);
        XWPFRun run = paragraph.createRun();
        try {
            void var3_6;
            run.addPicture(in, picType.getValue(), (String)var3_6, Units.toEMU((double)width), Units.toEMU((double)height));
        }
        catch (InvalidFormatException e) {
            try {
                throw new POIException(e);
                catch (IOException e2) {
                    void var2_4;
                    throw new IORuntimeException((Throwable)var2_4);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return this;
    }

    public Word07Writer flush() throws IORuntimeException {
        Word07Writer word07Writer = this;
        return word07Writer.flush(word07Writer.destFile);
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer flush(File destFile) throws IORuntimeException {
        void var1_1;
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(FileUtil.getOutputStream((File)var1_1), true);
    }

    /*
     * WARNING - void declaration
     */
    public Word07Writer flush(OutputStream out) throws IORuntimeException {
        void var1_1;
        return this.flush((OutputStream)var1_1, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Word07Writer flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "WordWriter has been closed!", new Object[0]);
        try {
            this.doc.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                void var3_3;
                throw new IORuntimeException((Throwable)var3_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                void var2_2;
                if (var2_2 == false) throw throwable;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        IoUtil.close(out);
        return this;
    }

    @Override
    public void close() {
        if (this.destFile != null) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        IoUtil.close((Closeable)this.doc);
        this.isClosed = true;
    }
}

