/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.word;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TableUtil {
    public static XWPFTable createTable(XWPFDocument doc) {
        return TableUtil.createTable(doc, null);
    }

    /*
     * WARNING - void declaration
     */
    public static XWPFTable createTable(XWPFDocument doc, Iterable<?> data) {
        void var1_1;
        XWPFDocument xWPFDocument;
        Assert.notNull(doc, "XWPFDocument must be not null !", new Object[0]);
        XWPFDocument table = doc.createTable();
        table.removeRow(0);
        return TableUtil.writeTable((XWPFTable)xWPFDocument, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static XWPFTable writeTable(XWPFTable table, Iterable<?> data) {
        XWPFTable xWPFTable;
        Iterator iterator;
        Assert.notNull(table, "XWPFTable must be not null !", new Object[0]);
        if (IterUtil.isEmpty(data)) {
            return table;
        }
        boolean isFirst = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object rowData = iterator.next();
            TableUtil.writeRow(table.createRow(), var3_3, isFirst);
            if (!isFirst) continue;
            isFirst = false;
        }
        return xWPFTable;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeRow(XWPFTableRow row, Object rowBean, boolean isWriteKeyAsHead) {
        void var2_2;
        void var1_1;
        XWPFTableRow xWPFTableRow;
        while (true) {
            Object rowMap;
            if (rowBean instanceof Iterable) {
                TableUtil.writeRow(row, (Iterable)rowBean);
                return;
            }
            if (rowBean instanceof Map) {
                rowMap = (Map<String, Object>)rowBean;
                break;
            }
            if (BeanUtil.isBean(rowMap.getClass())) {
                rowMap = BeanUtil.beanToMap(rowMap, new LinkedHashMap<String, Object>(), false, false);
                break;
            }
            rowMap = CollUtil.newArrayList(rowMap);
        }
        TableUtil.writeRow(xWPFTableRow, var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeRow(XWPFTableRow row, Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        void var1_1;
        XWPFTableRow xWPFTableRow;
        void var2_2;
        if (MapUtil.isEmpty(rowMap)) {
            return;
        }
        if (var2_2 != false) {
            TableUtil.writeRow(row, rowMap.keySet());
            row = row.getTable().createRow();
        }
        TableUtil.writeRow(xWPFTableRow, var1_1.values());
    }

    public static void writeRow(XWPFTableRow row, Iterable<?> rowData) {
        XWPFTableCell xWPFTableCell;
        int index = 0;
        for (Object cellData : xWPFTableCell) {
            xWPFTableCell = TableUtil.getOrCreateCell(row, index);
            xWPFTableCell.setText(Convert.toStr(cellData));
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static XWPFTableRow getOrCreateRow(XWPFTable table, int index) {
        void var1_2;
        XWPFTableRow row = table.getRow(index);
        if (row == null) {
            XWPFTable xWPFTable;
            row = xWPFTable.createRow();
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static XWPFTableCell getOrCreateCell(XWPFTableRow row, int index) {
        void var1_2;
        XWPFTableCell cell = row.getCell(index);
        if (cell == null) {
            XWPFTableRow xWPFTableRow;
            cell = xWPFTableRow.createCell();
        }
        return var1_2;
    }
}

