/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetRidReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<Integer, Integer> ID_RID_MAP = new LinkedHashMap<Integer, Integer>();
    private final Map<String, Integer> NAME_RID_MAP = new LinkedHashMap<String, Integer>();

    public static SheetRidReader parse(XSSFReader reader) {
        XSSFReader xSSFReader;
        return new SheetRidReader().read(xSSFReader);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SheetRidReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxUtil.readFrom(workbookData, this);
        }
        catch (InvalidFormatException e) {
            try {
                throw new POIException(e);
                catch (IOException e2) {
                    void var1_3;
                    throw new IORuntimeException((Throwable)var1_3);
                }
            }
            catch (Throwable throwable) {
                void var2_5;
                IoUtil.close((Closeable)var2_5);
                throw throwable;
            }
        }
        IoUtil.close(workbookData);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidBySheetId(int sheetId) {
        void var1_1;
        return this.ID_RID_MAP.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidBySheetIdBase0(int sheetId) {
        Integer rid = this.getRidBySheetId(sheetId + 1);
        if (rid != null) {
            void var1_2;
            return var1_2.intValue() - 1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidByName(String sheetName) {
        void var1_1;
        return this.NAME_RID_MAP.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidByNameBase0(String sheetName) {
        Integer rid = this.getRidByName(sheetName);
        if (rid != null) {
            void var1_1;
            return var1_1.intValue() - 1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidByIndex(int index) {
        void var1_1;
        return CollUtil.get(this.NAME_RID_MAP.values(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Integer getRidByIndexBase0(int index) {
        Integer rid = CollUtil.get(this.NAME_RID_MAP.values(), index);
        if (rid != null) {
            void var1_2;
            return var1_2.intValue() - 1;
        }
        return null;
    }

    public List<String> getSheetNames() {
        return ListUtil.toList(this.NAME_RID_MAP.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            String sheetIdStr;
            String ridStr = attributes.getValue(RID_ATTR);
            if (StrUtil.isEmpty(ridStr)) {
                return;
            }
            int rid = Integer.parseInt(StrUtil.removePrefixIgnoreCase(ridStr, "rId"));
            String name = attributes.getValue(NAME_ATTR);
            if (StrUtil.isNotEmpty(name)) {
                this.NAME_RID_MAP.put(name, rid);
            }
            if (StrUtil.isNotEmpty(sheetIdStr = attributes.getValue(SHEET_ID_ATTR))) {
                void var1_2;
                void var2_3;
                this.ID_RID_MAP.put(Integer.parseInt((String)var2_3), (int)var1_2);
            }
        }
    }
}

