/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.cell.FormulaCellValue;
import cn.hutool.poi.excel.sax.AttributeName;
import cn.hutool.poi.excel.sax.CellDataType;
import cn.hutool.poi.excel.sax.ElementName;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetDataSaxHandler
extends DefaultHandler {
    protected StylesTable stylesTable;
    protected SharedStrings sharedStrings;
    protected int sheetIndex;
    protected int index;
    private int curCell;
    private CellDataType cellDataType;
    private long rowNumber;
    private String curCoordinate;
    private ElementName curElementName;
    private String preCoordinate;
    private String maxCellCoordinate;
    private XSSFCellStyle xssfCellStyle;
    private String numFmtString;
    private boolean isInSheetData;
    private final StrBuilder lastContent = StrUtil.strBuilder();
    private final StrBuilder lastFormula = StrUtil.strBuilder();
    private List<Object> rowCellList = new ArrayList<Object>();
    protected RowHandler rowHandler;

    /*
     * WARNING - void declaration
     */
    public SheetDataSaxHandler(RowHandler rowHandler) {
        void var1_1;
        this.rowHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRowHandler(RowHandler rowHandler) {
        void var1_1;
        this.rowHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        void var3_3;
        ElementName name;
        if ("sheetData".equals(qName)) {
            this.isInSheetData = true;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = name = ElementName.of((String)var3_3);
        if (name != null) {
            void var1_1;
            switch (1.$SwitchMap$cn$hutool$poi$excel$sax$ElementName[var1_1.ordinal()]) {
                case 1: {
                    this.startRow(attributes);
                    return;
                }
                case 2: {
                    this.startCell(attributes);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        void var3_3;
        if ("sheetData".equals(qName)) {
            this.isInSheetData = false;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = null;
        if (ElementName.c.match(qName)) {
            this.endCell();
            return;
        }
        if (ElementName.row.match((String)var3_3)) {
            this.endRow();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void characters(char[] ch, int start, int length) {
        block6: {
            void var3_3;
            void var2_2;
            void var1_1;
            block5: {
                if (!this.isInSheetData) {
                    return;
                }
                ElementName elementName = this.curElementName;
                if (elementName == null) break block5;
                switch (elementName) {
                    case v: {
                        this.lastContent.append(ch, start, length);
                        break block6;
                    }
                    case f: {
                        this.lastFormula.append(ch, start, length);
                    }
                    default: {
                        return;
                    }
                }
            }
            this.lastContent.append((char[])var1_1, (int)var2_2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startRow(Attributes attributes) {
        void var1_1;
        String rValue = AttributeName.r.getValue(attributes);
        this.rowNumber = rValue == null ? -1L : Long.parseLong((String)var1_1) - 1L;
    }

    /*
     * WARNING - void declaration
     */
    private void startCell(Attributes attributes) {
        void var1_1;
        void var2_2;
        String tempCurCoordinate = AttributeName.r.getValue(attributes);
        this.preCoordinate = this.preCoordinate == null ? "@" : this.curCoordinate;
        this.curCoordinate = var2_2;
        this.setCellType((Attributes)var1_1);
        this.lastContent.reset();
        this.lastFormula.reset();
    }

    private void endRow() {
        if (this.index == 0) {
            this.maxCellCoordinate = this.curCoordinate;
        }
        if (this.maxCellCoordinate != null) {
            SheetDataSaxHandler sheetDataSaxHandler = this;
            sheetDataSaxHandler.fillBlankCell(sheetDataSaxHandler.curCoordinate, this.maxCellCoordinate, true);
        }
        this.rowHandler.handle(this.sheetIndex, this.rowNumber, this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.curCell + 1);
        ++this.index;
        this.curCell = 0;
        this.curCoordinate = null;
        this.preCoordinate = null;
    }

    /*
     * WARNING - void declaration
     */
    private void endCell() {
        void var1_1;
        SheetDataSaxHandler sheetDataSaxHandler = this;
        sheetDataSaxHandler.fillBlankCell(sheetDataSaxHandler.preCoordinate, this.curCoordinate, false);
        String contentStr = StrUtil.trim(this.lastContent);
        Object value = ExcelSaxUtil.getDataValue(this.cellDataType, contentStr, this.sharedStrings, this.numFmtString);
        if (!this.lastFormula.isEmpty()) {
            value = new FormulaCellValue(StrUtil.trim(this.lastFormula), value);
        }
        SheetDataSaxHandler sheetDataSaxHandler2 = this;
        sheetDataSaxHandler2.addCellValue(sheetDataSaxHandler2.curCell++, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addCellValue(int index, Object value) {
        void var2_2;
        void var1_1;
        this.rowCellList.add(index, value);
        this.rowHandler.handleCell(this.sheetIndex, this.rowNumber, (int)var1_1, var2_2, (CellStyle)this.xssfCellStyle);
    }

    /*
     * WARNING - void declaration
     */
    private void fillBlankCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            void var3_4;
            void var2_3;
            int len = ExcelSaxUtil.countNullCell(preCoordinate, (String)var2_3);
            if (var3_4 != false) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                SheetDataSaxHandler sheetDataSaxHandler = this;
                sheetDataSaxHandler.addCellValue(sheetDataSaxHandler.curCell++, "");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setCellType(Attributes attributes) {
        String xfIndexStr;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(AttributeName.t.getValue(attributes));
        if (this.stylesTable != null && (xfIndexStr = AttributeName.s.getValue(attributes)) != null) {
            void var1_2;
            this.xssfCellStyle = this.stylesTable.getStyleAt(Integer.parseInt(xfIndexStr));
            short numFmtIndex = this.xssfCellStyle.getDataFormat();
            this.numFmtString = ObjectUtil.defaultIfNull(this.xssfCellStyle.getDataFormatString(), () -> BuiltinFormats.getBuiltinFormat((int)numFmtIndex));
            if (CellDataType.NUMBER == this.cellDataType && ExcelSaxUtil.isDateFormat((int)var1_2, this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }
}

