/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.DependencyException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelDateUtil;
import cn.hutool.poi.excel.sax.CellDataType;
import cn.hutool.poi.excel.sax.Excel03SaxReader;
import cn.hutool.poi.excel.sax.Excel07SaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxUtil {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    /*
     * WARNING - void declaration
     */
    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        void var1_1;
        if (isXlsx) {
            return new Excel07SaxReader(rowHandler);
        }
        return new Excel03SaxReader((RowHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getDataValue(CellDataType cellDataType, String value, SharedStrings sharedStrings, String numFmtString) {
        Object object;
        if (value == null) {
            return null;
        }
        if (cellDataType == null) {
            cellDataType = CellDataType.NULL;
        }
        switch (cellDataType) {
            case BOOL: {
                Object result = value.charAt(0) != '0';
                break;
            }
            case ERROR: {
                Object result = StrUtil.format("\\\"ERROR: {} ", value);
                break;
            }
            case FORMULA: {
                Object result = StrUtil.format("\"{}\"", value);
                break;
            }
            case INLINESTR: {
                Object result = new XSSFRichTextString(value).toString();
                break;
            }
            case SSTINDEX: {
                Object result;
                try {
                    void var2_3;
                    int index = Integer.parseInt(value);
                    result = var2_3.getItemAt(index).getString();
                }
                catch (NumberFormatException numberFormatException) {
                    result = value;
                }
                break;
            }
            case NUMBER: {
                Object result;
                try {
                    void var3_4;
                    result = ExcelSaxUtil.getNumberValue(value, (String)var3_4);
                }
                catch (NumberFormatException numberFormatException) {
                    result = value;
                }
                break;
            }
            case DATE: {
                Object result;
                try {
                    result = ExcelSaxUtil.getDateValue(value);
                    break;
                }
                catch (Exception exception) {}
            }
            default: {
                void var1_2;
                Object result = var1_2;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        String string;
        if (numFmtString != null) {
            try {
                void var2_2;
                void var1_1;
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), (int)var1_1, (String)var2_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static int countNullCell(String preRef, String ref) {
        Object object;
        void var1_2;
        Object preXfd = StrUtil.nullToDefault(preRef, "@").replaceAll("\\d+", "");
        String xfd = StrUtil.nullToDefault(ref, "@").replaceAll("\\d+", "");
        preXfd = StrUtil.fillBefore((String)preXfd, '@', 3);
        xfd = StrUtil.fillBefore(xfd, '@', 3);
        Object preLetter = ((String)preXfd).toCharArray();
        char[] letter = xfd.toCharArray();
        int n = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (var1_2[2] - object[2]);
        return n - 1;
    }

    /*
     * WARNING - void declaration
     */
    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws DependencyException, POIException, IORuntimeException {
        void var1_3;
        Exception e;
        XMLReader xmlReader;
        try {
            xmlReader = XMLHelper.newXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            e = exception;
            if (exception.getMessage().contains("org.apache.xerces.parsers.SAXParser")) {
                throw new DependencyException(e, "You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0", new Object[0]);
            }
            throw new POIException(e);
        }
        xmlReader.setContentHandler((ContentHandler)var1_3);
        try {
            void var2_4;
            var2_4.parse(new InputSource((InputStream)((Object)e)));
            return;
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        catch (SAXException e3) {
            void var0_2;
            throw new POIException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDateFormat(CellValueRecordInterface cell, FormatTrackingHSSFListener formatListener) {
        Object object;
        void var2_2;
        void var1_1;
        int formatIndex = formatListener.getFormatIndex(cell);
        Object formatString = var1_1.getFormatString(cell);
        return ExcelSaxUtil.isDateFormat((int)var2_2, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDateFormat(int formatIndex, String formatString) {
        void var1_1;
        return ExcelDateUtil.isDateFormat(formatIndex, (String)var1_1);
    }

    public static DateTime getDateValue(String value) {
        return ExcelSaxUtil.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return DateUtil.date(org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)value, (boolean)false));
    }

    /*
     * WARNING - void declaration
     */
    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value, FormatTrackingHSSFListener formatListener) {
        CellValueRecordInterface cellValueRecordInterface;
        void var3_2;
        void var1_1;
        if (ExcelSaxUtil.isDateFormat(cell, formatListener)) {
            return ExcelSaxUtil.getDateValue(value);
        }
        return ExcelSaxUtil.getNumberValue((double)var1_1, var3_2.getFormatString(cellValueRecordInterface));
    }

    /*
     * WARNING - void declaration
     */
    private static Number getNumberValue(String value, String numFmtString) {
        void var1_1;
        String string;
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return ExcelSaxUtil.getNumberValue(Double.parseDouble(string), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Number getNumberValue(double numValue, String numFmtString) {
        double d;
        long longPart;
        void var2_1;
        if (numFmtString != null && !StrUtil.contains((CharSequence)var2_1, '.') && (double)(longPart = (long)numValue) == numValue) {
            void var3_2;
            return (long)var3_2;
        }
        return d;
    }
}

