/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.SheetDataSaxHandler;
import cn.hutool.poi.excel.sax.SheetRidReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private final SheetDataSaxHandler handler;

    /*
     * WARNING - void declaration
     */
    public Excel07SaxReader(RowHandler rowHandler) {
        void var1_1;
        this.handler = new SheetDataSaxHandler((RowHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        void var1_1;
        this.handler.setRowHandler((RowHandler)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel07SaxReader read(File file, int rid) throws POIException {
        void var2_2;
        void var1_1;
        return this.read((File)var1_1, "rId" + (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel07SaxReader read(File file, String idOrRidOrSheetName) throws POIException {
        Object object;
        block12: {
            OPCPackage open2 = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
            Throwable throwable = null;
            try {
                object = this.read(open2, (String)object);
                if (open2 == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (open2 != null) {
                            if (throwable != null) {
                                try {
                                    open2.close();
                                }
                                catch (Throwable open2) {
                                    throwable.addSuppressed(open2);
                                }
                            } else {
                                open2.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | InvalidFormatException e) {
                    void var1_3;
                    throw new POIException((Throwable)var1_3);
                }
            }
            open2.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws POIException {
        void var2_2;
        void var1_1;
        return this.read((InputStream)var1_1, "rId" + (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel07SaxReader read(InputStream in, String idOrRidOrSheetName) throws POIException {
        Object object;
        block13: {
            OPCPackage opcPackage2 = OPCPackage.open((InputStream)in);
            Throwable throwable = null;
            try {
                object = this.read(opcPackage2, (String)object);
                if (opcPackage2 == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (opcPackage2 != null) {
                            if (throwable != null) {
                                try {
                                    opcPackage2.close();
                                }
                                catch (Throwable opcPackage2) {
                                    throwable.addSuppressed(opcPackage2);
                                }
                            } else {
                                opcPackage2.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                catch (InvalidFormatException e) {
                    void var1_4;
                    throw new POIException((Throwable)var1_4);
                }
            }
            opcPackage2.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws POIException {
        void var2_2;
        void var1_1;
        return this.read((OPCPackage)var1_1, "rId" + (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRidOrSheetName) throws POIException {
        try {
            void var2_4;
            return this.read(new XSSFReader(opcPackage), (String)var2_4);
        }
        catch (OpenXML4JException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            void var1_3;
            throw new IORuntimeException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        void var2_2;
        void var1_1;
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {}
        this.handler.sharedStrings = (SharedStrings)ReflectUtil.invoke((Object)xssfReader, "getSharedStringsTable", new Object[0]);
        return this.readSheets((XSSFReader)var1_1, (String)var2_2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        Object sheetInputStreams;
        this.handler.sheetIndex = this.getSheetIndex(xssfReader, idOrRidOrSheetName);
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex >= 0) {
                sheetInputStream = xssfReader.getSheet("rId" + (this.handler.sheetIndex + 1));
                ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                sheetInputStreams = runtimeException;
                throw runtimeException;
                catch (Exception e) {
                    void var1_2;
                    throw new POIException((Throwable)var1_2);
                }
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
        }
        IoUtil.close(sheetInputStream);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private int getSheetIndex(XSSFReader xssfReader, String idOrRidOrSheetName) {
        void var2_2;
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "rId")) {
            return Integer.parseInt(StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "rId"));
        }
        SheetRidReader ridReader = SheetRidReader.parse(xssfReader);
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "sheetName:")) {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName = StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "sheetName:"));
            if (rid != null) {
                return rid;
            }
        } else {
            Integer n;
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName);
            if (rid != null) {
                return n;
            }
            try {
                void var1_1;
                int sheetIndex = Integer.parseInt(idOrRidOrSheetName);
                n = var1_1.getRidBySheetIdBase0(sheetIndex);
                return ObjectUtil.defaultIfNull(n, sheetIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new IllegalArgumentException("Invalid rId or id or sheetName: " + (String)var2_2);
    }
}

