/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class Excel03SaxReader
implements ExcelSaxReader<Excel03SaxReader>,
HSSFListener {
    private final boolean isOutputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private final List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private boolean isOutputNextStringRecord;
    private List<Object> rowCellList = new ArrayList<Object>();
    private int rid = -1;
    private String sheetName;
    private int curRid = -1;
    private final RowHandler rowHandler;

    /*
     * WARNING - void declaration
     */
    public Excel03SaxReader(RowHandler rowHandler) {
        void var1_1;
        this.rowHandler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel03SaxReader read(File file, String idOrRidOrSheetName) throws POIException {
        Object object;
        POIFSFileSystem poifsFileSystem2 = new POIFSFileSystem(file, true);
        Throwable throwable = null;
        try {
            object = this.read(poifsFileSystem2, (String)object);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            poifsFileSystem2.close();
                        }
                        catch (Throwable poifsFileSystem2) {
                            throwable.addSuppressed(poifsFileSystem2);
                        }
                    } else {
                        poifsFileSystem2.close();
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                void var1_3;
                throw new POIException((Throwable)var1_3);
            }
        }
        poifsFileSystem2.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Excel03SaxReader read(InputStream excelStream, String idOrRidOrSheetName) throws POIException {
        try {
            void var2_3;
            return this.read(new POIFSFileSystem(excelStream), (String)var2_3);
        }
        catch (IOException e) {
            void var1_2;
            throw new POIException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Excel03SaxReader read(POIFSFileSystem fs, String idOrRidOrSheetName) throws POIException {
        this.rid = this.getSheetIndex(idOrRidOrSheetName);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)this.formatListener);
        HSSFEventFactory factory = new HSSFEventFactory();
        try {
            void var3_5;
            var3_5.processWorkbookEvents(request, fs);
        }
        catch (IOException e) {
            try {
                void var2_3;
                throw new POIException((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)fs);
        return this;
    }

    public int getSheetIndex() {
        return this.rid;
    }

    public String getSheetName() {
        if (this.sheetName != null) {
            return this.sheetName;
        }
        if (this.boundSheetRecords.size() > this.rid) {
            return this.boundSheetRecords.get(this.rid >= 0 ? this.rid : this.curRid).getSheetname();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void processRecord(Record record) {
        Object currentSheetName;
        if (this.rid >= 0 && this.curRid > this.rid) {
            return;
        }
        if (record instanceof BoundSheetRecord) {
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
            this.boundSheetRecords.add(boundSheetRecord);
            currentSheetName = boundSheetRecord.getSheetname();
            if (this.sheetName != null && StrUtil.equals(this.sheetName, (CharSequence)currentSheetName)) {
                this.rid = this.boundSheetRecords.size() - 1;
            }
            return;
        }
        if (currentSheetName instanceof SSTRecord) {
            this.sstRecord = (SSTRecord)currentSheetName;
            return;
        }
        if (currentSheetName instanceof BOFRecord) {
            if ((currentSheetName = (BOFRecord)currentSheetName).getType() == 16) {
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.curRid;
            }
            return;
        }
        if (currentSheetName instanceof EOFRecord) {
            if (this.rid < 0 && this.sheetName != null) {
                throw new POIException("Sheet [{}] not exist!", this.sheetName);
            }
            if (this.curRid != -1 && this.isProcessCurrentSheet()) {
                this.processLastCellSheet();
                return;
            }
        } else if (this.isProcessCurrentSheet()) {
            void var1_1;
            if (currentSheetName instanceof MissingCellDummyRecord) {
                MissingCellDummyRecord mc = (MissingCellDummyRecord)currentSheetName;
                this.addToRowCellList((MissingCellDummyRecord)var1_1);
                return;
            }
            if (var1_1 instanceof LastCellOfRowDummyRecord) {
                this.processLastCell((LastCellOfRowDummyRecord)var1_1);
                return;
            }
            this.processCellValue((Record)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addToRowCellList(MissingCellDummyRecord record) {
        void var1_1;
        this.addToRowCellList(record.getRow(), var1_1.getColumn(), "");
    }

    /*
     * WARNING - void declaration
     */
    private void addToRowCellList(CellValueRecordInterface record, Object value) {
        void var2_2;
        void var1_1;
        this.addToRowCellList(record.getRow(), var1_1.getColumn(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void addToRowCellList(int row, int column, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        while (column > this.rowCellList.size()) {
            this.rowCellList.add("");
            this.rowHandler.handleCell(this.curRid, row, this.rowCellList.size() - 1, value, null);
        }
        this.rowCellList.add(column, value);
        this.rowHandler.handleCell(this.curRid, (long)var1_1, (int)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private void processCellValue(Record record) {
        Object value = null;
        switch (record.getSid()) {
            case 513: {
                this.addToRowCellList((CellValueRecordInterface)((BlankRecord)record), "");
                return;
            }
            case 517: {
                BoolErrRecord berec;
                BoolErrRecord boolErrRecord = berec = (BoolErrRecord)record;
                this.addToRowCellList((CellValueRecordInterface)boolErrRecord, boolErrRecord.getBooleanValue());
                return;
            }
            case 6: {
                BoolErrRecord berec;
                FormulaRecord formulaRec = (FormulaRecord)berec;
                if (Double.isNaN(formulaRec.getValue())) {
                    this.isOutputNextStringRecord = true;
                } else {
                    FormulaRecord formulaRecord = formulaRec;
                    value = ExcelSaxUtil.getNumberOrDateValue((CellValueRecordInterface)formulaRecord, formulaRecord.getValue(), this.formatListener);
                }
                this.addToRowCellList((CellValueRecordInterface)formulaRec, value);
                return;
            }
            case 519: {
                if (!this.isOutputNextStringRecord) break;
                this.isOutputNextStringRecord = false;
                return;
            }
            case 516: {
                FormulaRecord formulaRec;
                LabelRecord lrec = (LabelRecord)formulaRec;
                value = lrec.getValue();
                this.addToRowCellList((CellValueRecordInterface)lrec, value);
                return;
            }
            case 253: {
                LabelRecord lrec;
                LabelSSTRecord lsrec = (LabelSSTRecord)lrec;
                if (this.sstRecord != null) {
                    value = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                }
                this.addToRowCellList((CellValueRecordInterface)lsrec, ObjectUtil.defaultIfNull(value, ""));
                return;
            }
            case 515: {
                void var2_2;
                void var1_1;
                LabelSSTRecord lsrec;
                NumberRecord numrec = (NumberRecord)lsrec;
                value = ExcelSaxUtil.getNumberOrDateValue((CellValueRecordInterface)numrec, numrec.getValue(), this.formatListener);
                this.addToRowCellList((CellValueRecordInterface)var1_1, var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processLastCell(LastCellOfRowDummyRecord lastCell) {
        void var1_1;
        this.rowHandler.handle(this.curRid, var1_1.getRow(), this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.rowCellList.size());
    }

    private void processLastCellSheet() {
        this.rowHandler.doAfterAllAnalysed();
    }

    private boolean isProcessCurrentSheet() {
        return this.rid < 0 && this.sheetName == null || this.rid == this.curRid;
    }

    /*
     * WARNING - void declaration
     */
    private int getSheetIndex(String idOrRidOrSheetName) {
        Assert.notBlank(idOrRidOrSheetName, "id or rid or sheetName must be not blank!", new Object[0]);
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "rId")) {
            return Integer.parseInt(StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "rId"));
        }
        if (StrUtil.startWithIgnoreCase(idOrRidOrSheetName, "sheetName:")) {
            this.sheetName = StrUtil.removePrefixIgnoreCase(idOrRidOrSheetName, "sheetName:");
        } else {
            try {
                return Integer.parseInt(idOrRidOrSheetName);
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                this.sheetName = var1_1;
            }
        }
        return -1;
    }
}

