/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.reader.AbstractSheetReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class MapSheetReader
extends AbstractSheetReader<List<Map<String, Object>>> {
    private final int headerRowIndex;

    /*
     * WARNING - void declaration
     */
    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super((int)var2_2, (int)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.headerRowIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Map<String, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return ListUtil.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format("Header row index {} is lower than first row index {}.", this.headerRowIndex, firstRowNum));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format("Header row index {} is greater than last row index {}.", this.headerRowIndex, lastRowNum));
        }
        if (this.startRowIndex > lastRowNum) {
            return ListUtil.empty();
        }
        int startRowIndex = Math.max(this.startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.endRowIndex, lastRowNum);
        MapSheetReader mapSheetReader = this;
        List<String> headerList = mapSheetReader.aliasHeader(mapSheetReader.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            void var2_3;
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(sheet, i)) && this.ignoreEmptyRow) continue;
            result.add(IterUtil.toMap(headerList, var2_3, true));
        }
        return result;
    }
}

