/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell.setters;

import cn.hutool.poi.excel.cell.CellSetter;
import cn.hutool.poi.excel.cell.setters.BooleanCellSetter;
import cn.hutool.poi.excel.cell.setters.CalendarCellSetter;
import cn.hutool.poi.excel.cell.setters.CharSequenceCellSetter;
import cn.hutool.poi.excel.cell.setters.DateCellSetter;
import cn.hutool.poi.excel.cell.setters.HyperlinkCellSetter;
import cn.hutool.poi.excel.cell.setters.NullCellSetter;
import cn.hutool.poi.excel.cell.setters.NumberCellSetter;
import cn.hutool.poi.excel.cell.setters.RichTextCellSetter;
import cn.hutool.poi.excel.cell.setters.TemporalAccessorCellSetter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;

public class CellSetterFactory {
    public static CellSetter createCellSetter(Object value) {
        Object object;
        if (value == null) {
            return NullCellSetter.INSTANCE;
        }
        if (value instanceof CellSetter) {
            return (CellSetter)value;
        }
        if (value instanceof Date) {
            return new DateCellSetter((Date)value);
        }
        if (value instanceof TemporalAccessor) {
            return new TemporalAccessorCellSetter((TemporalAccessor)value);
        }
        if (value instanceof Calendar) {
            return new CalendarCellSetter((Calendar)value);
        }
        if (value instanceof Boolean) {
            return new BooleanCellSetter((Boolean)value);
        }
        if (value instanceof RichTextString) {
            return new RichTextCellSetter((RichTextString)value);
        }
        if (value instanceof Number) {
            return new NumberCellSetter((Number)value);
        }
        if (value instanceof Hyperlink) {
            return new HyperlinkCellSetter((Hyperlink)value);
        }
        return new CharSequenceCellSetter(object.toString());
    }
}

