/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellLocation;
import cn.hutool.poi.excel.cell.NullCell;
import cn.hutool.poi.excel.cell.setters.CellSetterFactory;
import cn.hutool.poi.excel.cell.values.ErrorCellValue;
import cn.hutool.poi.excel.cell.values.NumericCellValue;
import cn.hutool.poi.excel.editors.TrimEditor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;

public class CellUtil {
    public static Object getCellValue(Cell cell) {
        return CellUtil.getCellValue(cell, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        void var1_1;
        Cell cell2;
        if (cell == null) {
            return null;
        }
        Cell cell3 = cell2;
        return CellUtil.getCellValue(cell3, cell3.getCellType(), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        void var1_1;
        return CellUtil.getCellValue(cell, null, (CellEditor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        void var2_2;
        void var1_1;
        return CellUtil.getCellValue(cell, (CellType)var1_1, var2_2 != false ? new TrimEditor() : null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        void var1_1;
        Cell cell2;
        void var2_2;
        Object value;
        Cell mergedCell;
        if (cell == null) {
            return null;
        }
        if (cell instanceof NullCell) {
            if (cellEditor == null) {
                return null;
            }
            return cellEditor.edit(cell, null);
        }
        if (cellType == null) {
            cellType = cell.getCellType();
        }
        if ((mergedCell = CellUtil.getMergedRegionCell(cell)) != cell) {
            void var3_3;
            cell = var3_3;
            cellType = cell.getCellType();
        }
        switch (cellType) {
            case NUMERIC: {
                value = new NumericCellValue(cell).getValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                Cell cell3 = cell;
                value = CellUtil.getCellValue(cell3, cell3.getCachedFormulaResultType(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = new ErrorCellValue(cell).getValue();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        if (cellEditor == null) {
            return value;
        }
        return var2_2.edit(cell2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader) {
        void var1_1;
        Cell cell2;
        if (cell == null) {
            return;
        }
        if (styleSet != null) {
            void var3_3;
            void var2_2;
            cell.setCellStyle(var2_2.getStyleByValueType(value, (boolean)var3_3));
        }
        CellUtil.setCellValue(cell2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setCellValue(Cell cell, Object value, CellStyle style) {
        void var2_2;
        void var1_1;
        Cell cell2 = cell;
        CellUtil.setCellValue(cell2, arg_0 -> CellUtil.lambda$setCellValue$0(cell2, var1_1, (CellStyle)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static void setCellValue(Cell cell, Object value) {
        Cell cell2;
        void var1_1;
        if (cell == null) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(var1_1).setValue(cell2);
    }

    /*
     * WARNING - void declaration
     */
    public static Cell getCell(Row row, int cellIndex) {
        void var2_2;
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            void var1_1;
            Row row2;
            return new NullCell(row2, (int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Cell getOrCreateCell(Row row, int cellIndex) {
        void var2_2;
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            void var1_1;
            Row row2;
            cell = row2.createCell((int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        void var1_1;
        Sheet sheet2;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.isMergedRegion(sheet2, cellLocation.getX(), var1_1.getY());
    }

    public static boolean isMergedRegion(Cell cell) {
        Cell cell2;
        return CellUtil.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell2.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static CellRangeAddress getCellRangeAddress(Sheet sheet, String locationRef) {
        void var1_1;
        Sheet sheet2;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.getCellRangeAddress(sheet2, cellLocation.getX(), var1_1.getY());
    }

    public static CellRangeAddress getCellRangeAddress(Cell cell) {
        Cell cell2;
        return CellUtil.getCellRangeAddress(cell.getSheet(), cell.getColumnIndex(), cell2.getRowIndex());
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return ca;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void setMergedRegionStyle(Cell cell, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = CellUtil.getCellRangeAddress(cell);
        if (cellRangeAddress != null) {
            Cell cell2;
            void var2_2;
            void var1_1;
            CellUtil.setMergeCellStyle((CellStyle)var1_1, (CellRangeAddress)var2_2, cell2.getSheet());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CellUtil.mergingCells(sheet, (int)var1_1, (int)var2_2, (int)var3_3, lastColumn, null);
    }

    /*
     * WARNING - void declaration
     */
    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        void var1_2;
        Sheet sheet2;
        void var3_4;
        void var2_3;
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, (int)var2_3, (int)var3_4, lastColumn);
        CellUtil.setMergeCellStyle(cellStyle, cellRangeAddress, sheet);
        return sheet2.addMergedRegion((CellRangeAddress)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        void var1_1;
        Sheet sheet2;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.getMergedRegionValue(sheet2, cellLocation.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        void var2_2;
        void var1_1;
        return CellUtil.getCellValue(SheetUtil.getCell((Sheet)sheet, (int)var1_1, (int)var2_2));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        Cell cell2;
        if (cell == null) {
            return null;
        }
        return ObjectUtil.defaultIfNull(CellUtil.getCellIfMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex()), cell2);
    }

    /*
     * WARNING - void declaration
     */
    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        void var1_1;
        void var2_2;
        Sheet sheet2;
        return ObjectUtil.defaultIfNull(CellUtil.getCellIfMergedRegion(sheet, x, y), () -> CellUtil.lambda$getMergedRegionCell$1(sheet2, (int)var2_2, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        void var3_3;
        Cell cell2;
        void var2_2;
        void var1_1;
        Sheet sheet = cell.getSheet();
        Workbook wb = sheet.getWorkbook();
        Drawing drawing = sheet.createDrawingPatriarch();
        CreationHelper factory = wb.getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        Comment comment = drawing.createCellComment(anchor);
        comment.setAddress(cell.getAddress());
        comment.setString(factory.createRichTextString((String)var1_1));
        comment.setAuthor(StrUtil.nullToEmpty((CharSequence)var2_2));
        cell2.setCellComment((Comment)var3_3);
    }

    private static Cell getCellIfMergedRegion(Sheet sheet, int x, int y) {
        for (CellRangeAddress ca : sheet.getMergedRegions()) {
            if (!ca.isInRange(y, x)) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)ca.getFirstRow(), (int)ca.getFirstColumn());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void setMergeCellStyle(CellStyle cellStyle, CellRangeAddress cellRangeAddress, Sheet sheet) {
        if (cellStyle != null) {
            void var2_2;
            void var1_1;
            CellStyle cellStyle2;
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBottomBorderColor((int)cellStyle2.getBottomBorderColor(), (CellRangeAddress)var1_1, (Sheet)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Cell lambda$getMergedRegionCell$1(Sheet sheet, int y, int x) {
        void var2_2;
        void var1_1;
        return SheetUtil.getCell((Sheet)sheet, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$setCellValue$0(Cell cell, Object value, CellStyle style, Cell cell1) {
        void var1_1;
        CellUtil.setCellValue(cell, var1_1);
        if (style != null) {
            void var2_2;
            void var3_3;
            var3_3.setCellStyle((CellStyle)var2_2);
        }
    }
}

