/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtil {
    public static Workbook createBook(String excelFilePath) {
        return WorkbookUtil.createBook(excelFilePath, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(String excelFilePath, boolean readOnly) {
        void var1_1;
        return WorkbookUtil.createBook(FileUtil.file(excelFilePath), null, (boolean)var1_1);
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookUtil.createBook(excelFile, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(File excelFile, boolean readOnly) {
        void var1_1;
        return WorkbookUtil.createBook(excelFile, null, (boolean)var1_1);
    }

    public static Workbook createBookForWriter(File excelFile) {
        File file;
        if (excelFile == null) {
            return WorkbookUtil.createBook(true);
        }
        if (excelFile.exists()) {
            return WorkbookUtil.createBook(FileUtil.getInputStream(excelFile));
        }
        return WorkbookUtil.createBook(StrUtil.endWithIgnoreCase(file.getName(), ".xlsx"));
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(File excelFile, String password) {
        void var1_1;
        return WorkbookUtil.createBook(excelFile, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(File excelFile, String password, boolean readOnly) {
        try {
            void var2_3;
            void var1_2;
            return WorkbookFactory.create((File)excelFile, (String)var1_2, (boolean)var2_3);
        }
        catch (Exception e) {
            void var0_1;
            throw new POIException((Throwable)var0_1);
        }
    }

    public static Workbook createBook(InputStream in) {
        return WorkbookUtil.createBook(in, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(InputStream in, String password) {
        try {
            password = WorkbookFactory.create((InputStream)IoUtil.toMarkSupportStream(in), (String)password);
        }
        catch (Exception e) {
            try {
                void var1_2;
                throw new POIException((Throwable)var1_2);
            }
            catch (Throwable throwable) {
                InputStream inputStream;
                IoUtil.close(inputStream);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return password;
    }

    /*
     * WARNING - void declaration
     */
    public static Workbook createBook(boolean isXlsx) {
        try {
            return WorkbookFactory.create((boolean)isXlsx);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return WorkbookUtil.createSXSSFBook(excelFilePath, false);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(String excelFilePath, boolean readOnly) {
        void var1_1;
        return WorkbookUtil.createSXSSFBook(FileUtil.file(excelFilePath), null, (boolean)var1_1);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return WorkbookUtil.createSXSSFBook(excelFile, false);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(File excelFile, boolean readOnly) {
        void var1_1;
        return WorkbookUtil.createSXSSFBook(excelFile, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        void var1_1;
        return WorkbookUtil.createSXSSFBook(excelFile, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password, boolean readOnly) {
        void var2_2;
        void var1_1;
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(excelFile, (String)var1_1, (boolean)var2_2));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in) {
        return WorkbookUtil.createSXSSFBook(in, null);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password) {
        void var1_1;
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(in, (String)var1_1));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        int n;
        return new SXSSFWorkbook(n);
    }

    /*
     * WARNING - void declaration
     */
    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        void var2_2;
        void var1_1;
        int n;
        return new SXSSFWorkbook(null, n, (boolean)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            void var1_2;
            book.write((OutputStream)var1_2);
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        void var2_2;
        if (book == null) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StrUtil.isBlank(sheetName) ? "sheet1" : sheetName);
        if (sheet == null) {
            void var1_1;
            Workbook workbook;
            sheet = workbook.createSheet((String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        void var2_2;
        Sheet sheet = null;
        try {
            void var1_1;
            sheet = book.getSheetAt((int)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (sheet == null) {
            Workbook workbook;
            sheet = workbook.createSheet();
        }
        return var2_2;
    }

    public static boolean isEmpty(Sheet sheet) {
        Sheet sheet2;
        return sheet == null || sheet.getLastRowNum() == 0 && sheet2.getPhysicalNumberOfRows() == 0;
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            Workbook workbook;
            return new SXSSFWorkbook((XSSFWorkbook)workbook);
        }
        throw new POIException("The input is not a [xlsx] format.");
    }
}

