/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.poi.excel.style.StyleUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Workbook workbook;
    protected final CellStyle headCellStyle;
    protected final CellStyle cellStyle;
    protected final CellStyle cellStyleForNumber;
    protected final CellStyle cellStyleForDate;
    protected final CellStyle cellStyleForHyperlink;

    /*
     * WARNING - void declaration
     */
    public StyleSet(Workbook workbook) {
        void var1_1;
        this.workbook = workbook;
        this.headCellStyle = StyleUtil.createHeadCellStyle(workbook);
        this.cellStyle = StyleUtil.createDefaultCellStyle(workbook);
        this.cellStyleForNumber = StyleUtil.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForNumber.setDataFormat((short)2);
        this.cellStyleForDate = StyleUtil.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForDate.setDataFormat((short)22);
        this.cellStyleForHyperlink = StyleUtil.cloneCellStyle(workbook, this.cellStyle);
        Font font = this.workbook.createFont();
        font.setUnderline((byte)1);
        font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        this.cellStyleForHyperlink.setFont((Font)var1_1);
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getCellStyleForNumber() {
        return this.cellStyleForNumber;
    }

    public CellStyle getCellStyleForDate() {
        return this.cellStyleForDate;
    }

    public CellStyle getCellStyleForHyperlink() {
        return this.cellStyleForHyperlink;
    }

    /*
     * WARNING - void declaration
     */
    public StyleSet setBorder(BorderStyle borderSize, IndexedColors colorIndex) {
        void var2_2;
        void var1_1;
        StyleUtil.setBorder(this.headCellStyle, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyle, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyleForNumber, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyleForDate, borderSize, colorIndex);
        StyleUtil.setBorder(this.cellStyleForHyperlink, (BorderStyle)var1_1, (IndexedColors)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StyleSet setAlign(HorizontalAlignment halign, VerticalAlignment valign) {
        void var2_2;
        void var1_1;
        StyleUtil.setAlign(this.headCellStyle, halign, valign);
        StyleUtil.setAlign(this.cellStyle, halign, valign);
        StyleUtil.setAlign(this.cellStyleForNumber, halign, valign);
        StyleUtil.setAlign(this.cellStyleForDate, halign, valign);
        StyleUtil.setAlign(this.cellStyleForHyperlink, (HorizontalAlignment)var1_1, (VerticalAlignment)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StyleSet setBackgroundColor(IndexedColors backgroundColor, boolean withHeadCell) {
        void var1_1;
        if (withHeadCell) {
            StyleUtil.setColor(this.headCellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        }
        StyleUtil.setColor(this.cellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleUtil.setColor(this.cellStyleForNumber, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleUtil.setColor(this.cellStyleForDate, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        StyleUtil.setColor(this.cellStyleForHyperlink, (IndexedColors)var1_1, FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StyleSet setFont(short color, short fontSize, String fontName, boolean ignoreHead) {
        void var1_2;
        void var3_4;
        void var2_3;
        Font font = StyleUtil.createFont(this.workbook, color, (short)var2_3, (String)var3_4);
        return this.setFont((Font)var1_2, ignoreHead);
    }

    /*
     * WARNING - void declaration
     */
    public StyleSet setFont(Font font, boolean ignoreHead) {
        void var1_1;
        if (!ignoreHead) {
            this.headCellStyle.setFont(font);
        }
        this.cellStyle.setFont(font);
        this.cellStyleForNumber.setFont(font);
        this.cellStyleForDate.setFont(font);
        this.cellStyleForHyperlink.setFont((Font)var1_1);
        return this;
    }

    public StyleSet setWrapText() {
        this.cellStyle.setWrapText(true);
        this.cellStyleForNumber.setWrapText(true);
        this.cellStyleForDate.setWrapText(true);
        this.cellStyleForHyperlink.setWrapText(true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getStyleByValueType(Object value, boolean isHeader) {
        void var3_3;
        void var1_1;
        void var2_2;
        CellStyle style = null;
        if (var2_2 != false && this.headCellStyle != null) {
            style = this.headCellStyle;
        } else if (this.cellStyle != null) {
            style = this.cellStyle;
        }
        if (value instanceof Date || value instanceof TemporalAccessor || value instanceof Calendar) {
            if (this.cellStyleForDate != null) {
                style = this.cellStyleForDate;
            }
        } else if (value instanceof Number) {
            if ((value instanceof Double || value instanceof Float || value instanceof BigDecimal) && this.cellStyleForNumber != null) {
                style = this.cellStyleForNumber;
            }
        } else if (var1_1 instanceof Hyperlink && this.cellStyleForHyperlink != null) {
            style = this.cellStyleForHyperlink;
        }
        return var3_3;
    }
}

