/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeUtil;

public class RowUtil {
    /*
     * WARNING - void declaration
     */
    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        void var2_2;
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            void var1_1;
            Sheet sheet2;
            row = sheet2.createRow((int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> readRow(Row row, CellEditor cellEditor) {
        void var1_1;
        return RowUtil.readRow(row, 0, Short.MAX_VALUE, (CellEditor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> readRow(Row row, int startCellNumInclude, int endCellNumInclude, CellEditor cellEditor) {
        if (row == null) {
            return new ArrayList<Object>(0);
        }
        short rowLength = row.getLastCellNum();
        if (rowLength < 0) {
            return ListUtil.empty();
        }
        int size = Math.min(endCellNumInclude + 1, rowLength);
        ArrayList<Object> cellValues = new ArrayList<Object>(size);
        boolean isAllNull = true;
        for (int i = startCellNumInclude; i < size; ++i) {
            void var1_2;
            Object cellValue = CellUtil.getCellValue(CellUtil.getCell(row, i), cellEditor);
            isAllNull &= StrUtil.isEmptyIfStr(cellValue);
            cellValues.add(var1_2);
        }
        if (isAllNull) {
            return ListUtil.empty();
        }
        return cellValues;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeRow(Row row, Iterable<?> rowData) {
        void var1_1;
        RowUtil.writeRow(row, var1_1, null, false);
    }

    public static void writeRow(Row row, Iterable<?> rowData, StyleSet styleSet, boolean isHeader) {
        Cell cell;
        int i = 0;
        for (Object value : cell) {
            cell = row.createCell(i);
            CellUtil.setCellValue(cell, value, styleSet, isHeader);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void insertRow(Sheet sheet, int startRow, int insertNumber) {
        void var3_3;
        Sheet sheet2;
        void var2_2;
        void var1_1;
        if (insertNumber <= 0) {
            return;
        }
        Row sourceRow = RowUtil.getOrCreateRow(sheet, startRow);
        sheet.shiftRows(startRow, sheet.getLastRowNum(), insertNumber, true, false);
        void v0 = var1_1;
        IntStream.range((int)v0, (int)(v0 + var2_2)).forEachOrdered(arg_0 -> RowUtil.lambda$insertRow$1(sheet2, (Row)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static void removeRow(Row row) {
        void var1_1;
        Row removingRow;
        void var2_2;
        if (row == null) {
            return;
        }
        int rowIndex = row.getRowNum();
        Row sheet = row.getSheet();
        int lastRow = sheet.getLastRowNum();
        if (rowIndex >= 0 && rowIndex < lastRow) {
            ArrayList updateMergedRegions = new ArrayList();
            IntStream.range(0, sheet.getNumMergedRegions()).forEach(arg_0 -> RowUtil.lambda$removeRow$2((Sheet)sheet, rowIndex, updateMergedRegions, arg_0));
            sheet.shiftRows(rowIndex + 1, lastRow, -1);
            List removeMergedRegions = IntStream.range(0, sheet.getNumMergedRegions()).filter(arg_0 -> RowUtil.lambda$removeRow$4(updateMergedRegions, (Sheet)sheet, arg_0)).boxed().collect(Collectors.toList());
            sheet.removeMergedRegions(removeMergedRegions);
            updateMergedRegions.forEach(arg_0 -> RowUtil.lambda$removeRow$5((Sheet)sheet, arg_0));
            sheet.validateMergedRegions();
        }
        if (rowIndex == var2_2 && (removingRow = sheet.getRow((int)var1_1)) != null) {
            void var3_3;
            Row row2;
            row2.removeRow((Row)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$removeRow$5(Sheet sheet, CellRangeAddress mr) {
        void var1_1;
        Sheet sheet2;
        CellRangeAddress cellRangeAddress = mr;
        cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() - 1);
        sheet2.addMergedRegion((CellRangeAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$removeRow$4(List updateMergedRegions, Sheet sheet, int i) {
        void var2_2;
        void var1_1;
        return updateMergedRegions.stream().anyMatch(arg_0 -> RowUtil.lambda$null$3((Sheet)var1_1, (int)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$null$3(Sheet sheet, int i, CellRangeAddress umr) {
        void var1_1;
        Sheet sheet2;
        return CellRangeUtil.contains((CellRangeAddress)umr, (CellRangeAddress)sheet2.getMergedRegion((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$removeRow$2(Sheet sheet, int rowIndex, List updateMergedRegions, int i) {
        Sheet sheet2;
        void var2_2;
        void var1_1;
        void var3_3;
        Sheet mr = sheet.getMergedRegion((int)var3_3);
        if (!mr.containsRow((int)var1_1)) {
            return;
        }
        if (mr.getFirstRow() == mr.getLastRow() - 1 && mr.getFirstColumn() == mr.getLastColumn()) {
            return;
        }
        var2_2.add(sheet2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$insertRow$1(Sheet sheet, Row sourceRow, int i) {
        void var1_1;
        Sheet sheet2;
        void var2_2;
        Sheet row = sheet.createRow(i);
        row.setHeightInPoints(sourceRow.getHeightInPoints());
        short lastCellNum = sourceRow.getLastCellNum();
        IntStream.range(0, (int)var2_2).forEachOrdered(arg_0 -> RowUtil.lambda$null$0((Row)sheet2, (Row)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$null$0(Row row, Row sourceRow, int j) {
        void var2_2;
        void var1_1;
        Row row2 = row.createCell(j);
        row2.setCellStyle(var1_1.getCell((int)var2_2).getCellStyle());
    }
}

