/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.IndexedComparator;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.map.TableMap;
import cn.hutool.core.map.multi.RowKeyTable;
import cn.hutool.core.map.multi.Table;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.poi.excel.ExcelBase;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.WorkbookUtil;
import cn.hutool.poi.excel.cell.CellLocation;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.Align;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    private final AtomicInteger currentRow;
    private boolean onlyAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet;
    private Map<String, Integer> headLocationCache;

    public ExcelWriter() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(boolean isXlsx) {
        this(WorkbookUtil.createBook((boolean)var1_1), null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(String destFilePath) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(WorkbookUtil.createBook((boolean)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file((String)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(File destFile) {
        this((File)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(File destFile, String sheetName) {
        this(WorkbookUtil.createBookForWriter(destFile), (String)var2_2);
        void var1_1;
        void var2_2;
        this.destFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(Workbook workbook, String sheetName) {
        this(WorkbookUtil.getOrCreateSheet((Workbook)var1_1, (String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter(Sheet sheet) {
        super((Sheet)var1_1);
        void var1_1;
        this.styleSet = new StyleSet(this.workbook);
        this.currentRow = new AtomicInteger(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        void var1_1;
        this.reset();
        return (ExcelWriter)super.setSheet((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExcelWriter setSheet(String sheetName) {
        void var1_1;
        this.reset();
        return (ExcelWriter)super.setSheet((String)var1_1);
    }

    public ExcelWriter reset() {
        this.resetRow();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExcelWriter renameSheet(String sheetName) {
        void var1_1;
        ExcelWriter excelWriter = this;
        return excelWriter.renameSheet(excelWriter.workbook.getSheetIndex(this.sheet), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter renameSheet(int sheet, String sheetName) {
        void var2_2;
        void var1_1;
        this.workbook.setSheetName((int)var1_1, (String)var2_2);
        return this;
    }

    public ExcelWriter autoSizeColumnAll() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter autoSizeColumn(int columnIndex) {
        void var1_1;
        this.sheet.autoSizeColumn((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        void var2_2;
        void var1_1;
        this.sheet.autoSizeColumn((int)var1_1, (boolean)var2_2);
        return this;
    }

    public ExcelWriter disableDefaultStyle() {
        return this.setStyleSet(null);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setStyleSet(StyleSet styleSet) {
        void var1_1;
        this.styleSet = var1_1;
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        if (this.styleSet == null) {
            return null;
        }
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    /*
     * WARNING - void declaration
     */
    public String getDisposition(String fileName, Charset charset) {
        void var1_1;
        void var2_2;
        if (charset == null) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        if (StrUtil.isBlank(fileName)) {
            fileName = IdUtil.fastSimpleUUID();
        }
        fileName = StrUtil.addSuffixIfNot(URLUtil.encodeAll(fileName, (Charset)var2_2), this.isXlsx() ? ".xlsx" : ".xls");
        return StrUtil.format("attachment; filename=\"{}\"", var1_1);
    }

    public String getContentType() {
        if (this.isXlsx()) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        return "application/vnd.ms-excel";
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setCurrentRow(int rowIndex) {
        void var1_1;
        this.currentRow.set((int)var1_1);
        return this;
    }

    public ExcelWriter setCurrentRowToEnd() {
        ExcelWriter excelWriter = this;
        return excelWriter.setCurrentRow(excelWriter.getRowCount());
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter passRows(int rows) {
        void var1_1;
        this.currentRow.addAndGet((int)var1_1);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setDestFile(File destFile) {
        void var1_1;
        this.destFile = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        void var1_1;
        this.aliasComparator = null;
        return (ExcelWriter)super.setHeaderAlias((Map<String, String>)var1_1);
    }

    @Override
    public ExcelWriter clearHeaderAlias() {
        this.aliasComparator = null;
        return (ExcelWriter)super.clearHeaderAlias();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExcelWriter addHeaderAlias(String name, String alias) {
        void var2_2;
        void var1_1;
        this.aliasComparator = null;
        return (ExcelWriter)super.addHeaderAlias((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setOnlyAlias(boolean isOnlyAlias) {
        void var1_1;
        this.onlyAlias = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setFreezePane(int rowSplit) {
        void var1_1;
        return this.setFreezePane(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setFreezePane(int colSplit, int rowSplit) {
        void var2_2;
        void var1_1;
        this.getSheet().createFreezePane((int)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            void var2_2;
            void var1_1;
            this.sheet.setColumnWidth((int)var1_1, (int)(var2_2 << 8));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setDefaultRowHeight(int height) {
        void var1_1;
        return this.setRowHeight(-1, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rownum);
            if (row != null) {
                void var2_3;
                void var1_2;
                var1_2.setHeightInPoints((float)var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        void var2_2;
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (1.$SwitchMap$cn$hutool$poi$excel$style$Align[var2_2.ordinal()]) {
            case 1: {
                headerFooter.setLeft(text);
                break;
            }
            case 2: {
                headerFooter.setRight(text);
                break;
            }
            case 3: {
                void var1_1;
                void var3_4;
                var3_4.setCenter((String)var1_1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        void var3_3;
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        void v1 = var1_1;
        return this.addSelect(new CellRangeAddressList((int)v0, (int)v0, (int)v1, (int)v1), (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        void var1_1;
        void var2_2;
        void var3_3;
        DataValidationHelper validationHelper = this.sheet.getDataValidationHelper();
        DataValidationConstraint constraint = validationHelper.createExplicitListConstraint(selectList);
        DataValidation dataValidation = var3_3.createValidation((DataValidationConstraint)var2_2, regions);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        return this.addValidationData((DataValidation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter addValidationData(DataValidation dataValidation) {
        void var1_1;
        this.sheet.addValidationData((DataValidation)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter merge(int lastColumn) {
        void var1_1;
        return this.merge((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter merge(int lastColumn, Object content) {
        void var2_2;
        void var1_1;
        return this.merge((int)var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        void var2_2;
        void var3_3;
        void var1_1;
        int rowIndex;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int n = rowIndex = this.currentRow.get();
        this.merge(n, n, 0, (int)var1_1, content, (boolean)var3_3);
        if (var2_2 != null) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, boolean isSetHeaderStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        CellStyle style = null;
        if (this.styleSet != null) {
            style = this.styleSet.getStyleByValueType(content, isSetHeaderStyle);
        }
        return this.merge((int)var1_1, (int)var2_2, (int)var3_3, lastColumn, content, style);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, CellStyle cellStyle) {
        void var2_3;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        CellUtil.mergingCells(this.getSheet(), firstRow, (int)var2_3, firstColumn, lastColumn, cellStyle);
        if (content != null) {
            void var1_1;
            void var3_4;
            Cell cell = this.getOrCreateCell((int)var3_4, (int)var1_1);
            CellUtil.setCellValue(cell, content, cellStyle);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter write(Iterable<?> data) {
        void var1_1;
        return this.write((Iterable<?>)var1_1, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        Iterator iterator;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirst = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            void var1_1;
            Map<String, Object> map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = BeanUtil.beanToMap(obj, new TreeMap<String, Object>(comparator), false, false);
            }
            this.writeRow((Map<?, ?>)var1_1, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeImg(File imgFile, int col1, int row1, int col2, int row2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeImg((File)var1_1, 0, 0, 0, 0, (int)var2_2, (int)var3_3, col2, row2);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeImg(File imgFile, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeImg((File)var1_1, 6, (int)var2_2, (int)var3_3, dx2, dy2, col1, row1, col2, row2);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeImg(File imgFile, int imgType, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeImg(FileUtil.readBytes((File)var1_1), (int)var2_2, (int)var3_3, dy1, dx2, dy2, col1, row1, col2, row2);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeImg(byte[] pictureData, int imgType, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        void var2_2;
        void var1_1;
        void var3_3;
        Drawing patriarch = this.sheet.createDrawingPatriarch();
        ClientAnchor anchor = this.workbook.getCreationHelper().createClientAnchor();
        anchor.setDx1((int)var3_3);
        anchor.setDy1(dy1);
        anchor.setDx2(dx2);
        anchor.setDy2(dy2);
        anchor.setCol1(col1);
        anchor.setRow1(row1);
        anchor.setCol2(col2);
        anchor.setRow2(row2);
        patriarch.createPicture(anchor, this.workbook.addPicture((byte[])var1_1, (int)var2_2));
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Cell cell;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        this.headLocationCache = new SafeConcurrentHashMap<String, Integer>();
        Row row = this.sheet.createRow(this.currentRow.getAndIncrement());
        int i = 0;
        for (Object value : cell) {
            cell = row.createCell(i);
            CellUtil.setCellValue(cell, value, this.styleSet, true);
            this.headLocationCache.put(StrUtil.toString(value), i);
            ++i;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeSecHeadRow(Iterable<?> rowData) {
        Row row = RowUtil.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
        Iterator<?> iterator = rowData.iterator();
        if (row.getLastCellNum() != 0) {
            for (int i = 0; i < this.workbook.getSpreadsheetVersion().getMaxColumns(); ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) continue;
                if (iterator.hasNext()) {
                    cell = row.createCell(i);
                    CellUtil.setCellValue(cell, iterator.next(), this.styleSet, true);
                    continue;
                }
                break;
            }
        } else {
            void var1_1;
            this.writeHeadRow((Iterable<?>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        void var2_2;
        void var1_1;
        Map<String, Object> rowMap;
        if (rowBean instanceof Map) {
            rowMap = MapUtil.isNotEmpty(this.headerAlias) ? MapUtil.newTreeMap((Map)rowBean, this.getCachedAliasComparator()) : (TreeMap)rowMap;
        } else {
            if (rowMap instanceof Iterable) {
                return this.writeRow((Iterable)((Object)rowMap));
            }
            if (rowMap instanceof Hyperlink) {
                return this.writeRow(CollUtil.newArrayList(rowMap), isWriteKeyAsHead);
            }
            if (BeanUtil.isBean(rowMap.getClass())) {
                rowMap = MapUtil.isEmpty(this.headerAlias) ? BeanUtil.beanToMap(rowMap, new LinkedHashMap<String, Object>(), false, false) : BeanUtil.beanToMap(rowMap, new TreeMap<String, Object>(this.getCachedAliasComparator()), false, false);
            } else {
                return this.writeRow(CollUtil.newArrayList(rowMap), isWriteKeyAsHead);
            }
        }
        return this.writeRow((Map<?, ?>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Iterator<?> iterator;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (MapUtil.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        Table<?, ?, ?> aliasTable = this.aliasTable(rowMap);
        if (isWriteKeyAsHead != false) {
            this.writeHeadRow(aliasTable.columnKeys());
            int i = 0;
            iterator = aliasTable.rowKeySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.headLocationCache.putIfAbsent(StrUtil.toString(key), i);
                ++i;
            }
        }
        if (MapUtil.isNotEmpty(this.headLocationCache)) {
            Row row = RowUtil.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            for (Table.Cell cell : aliasTable) {
                void var1_4;
                Integer location = this.headLocationCache.get(StrUtil.toString(cell.getRowKey()));
                if (location == null) {
                    location = this.headLocationCache.get(StrUtil.toString(cell.getColumnKey()));
                }
                if (location == null) continue;
                CellUtil.setCellValue(CellUtil.getOrCreateCell(row, (Integer)((Object)iterator)), var1_4.getValue(), this.styleSet, false);
            }
        } else {
            void var1_2;
            this.writeRow(var1_2.values());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeRow(Iterable<?> rowData) {
        void var1_1;
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RowUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), var1_1, this.styleSet, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, boolean isWriteKeyAsHead) {
        void var2_2;
        void var1_1;
        return this.writeCol((Map<?, ? extends Iterable<?>>)var1_1, 0, (boolean)var2_2);
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, int startColIndex, boolean isWriteKeyAsHead) {
        for (Object k : colMap.keySet()) {
            Iterable<?> v = colMap.get(k);
            if (v == null) continue;
            this.writeCol(isWriteKeyAsHead ? k : null, startColIndex, v, startColIndex != colMap.size() - 1);
            ++startColIndex;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCol(Object headerVal, Iterable<?> colData, boolean isResetRowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeCol(var1_1, 0, (Iterable<?>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCol(Object headerVal, int colIndex, Iterable<?> colData, boolean isResetRowIndex) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int currentRowIndex = this.currentRow.get();
        if (headerVal != null) {
            Iterator<?> iterator;
            this.writeCellValue(colIndex, currentRowIndex, iterator, true);
            ++currentRowIndex;
        }
        for (Object colDatum : colData) {
            void var3_3;
            this.writeCellValue(colIndex, currentRowIndex, var3_3);
            ++currentRowIndex;
        }
        if (!isResetRowIndex) {
            this.currentRow.set(currentRowIndex);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCellValue(String locationRef, Object value) {
        void var2_2;
        void var1_1;
        return this.writeCellValue((String)var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCellValue(String locationRef, Object value, boolean isHeader) {
        void var3_3;
        void var2_2;
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.writeCellValue(cellLocation.getX(), var1_1.getY(), var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCellValue(int x, int y, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeCellValue((int)var1_1, (int)var2_2, var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter writeCellValue(int x, int y, Object value, boolean isHeader) {
        void var3_4;
        void var2_3;
        void var1_1;
        Cell cell = this.getOrCreateCell((int)var1_1, (int)var2_3);
        CellUtil.setCellValue(cell, var3_4, this.styleSet, isHeader);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setStyle(CellStyle style, String locationRef) {
        void var2_2;
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.setStyle((CellStyle)var1_1, cellLocation.getX(), var2_2.getY());
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        void var1_1;
        void var3_4;
        void var2_2;
        Cell cell = this.getOrCreateCell((int)var2_2, (int)var3_4);
        cell.setCellStyle((CellStyle)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setRowStyle(int y, CellStyle style) {
        void var2_2;
        void var1_1;
        this.getOrCreateRow((int)var1_1).setRowStyle((CellStyle)var2_2);
        return this;
    }

    public ExcelWriter setRowStyleIfHasData(int y, CellStyle style) {
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.setStyle(style, i, y);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setColumnStyle(int x, CellStyle style) {
        void var2_2;
        void var1_1;
        this.sheet.setDefaultColumnStyle((int)var1_1, (CellStyle)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter setColumnStyleIfHasData(int x, int y, CellStyle style) {
        void i;
        if (x < 0) {
            throw new IllegalArgumentException("Invalid column number (" + x + ")");
        }
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int rowCount = this.getRowCount();
        while (i < rowCount) {
            this.setStyle(style, x, (int)i);
            ++i;
        }
        return this;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public ExcelWriter flush() throws IORuntimeException {
        ExcelWriter excelWriter = this;
        return excelWriter.flush(excelWriter.destFile);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter flush(File destFile) throws IORuntimeException {
        void var1_1;
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(FileUtil.getOutputStream((File)var1_1), true);
    }

    /*
     * WARNING - void declaration
     */
    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        void var1_1;
        return this.flush((OutputStream)var1_1, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                void var3_3;
                throw new IORuntimeException((Throwable)var3_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                void var2_2;
                if (var2_2 == false) throw throwable;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        IoUtil.close(out);
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow.set(0);
        this.styleSet = null;
    }

    /*
     * WARNING - void declaration
     */
    private Table<?, ?, ?> aliasTable(Map<?, ?> rowMap) {
        void var2_2;
        RowKeyTable filteredTable = new RowKeyTable(new LinkedHashMap(), TableMap::new);
        if (MapUtil.isEmpty(this.headerAlias)) {
            rowMap.forEach((key, value) -> {
                void var2_2;
                void var1_1;
                void v0 = var1_1;
                filteredTable.put(v0, v0, var2_2);
            });
        } else {
            void var1_1;
            var1_1.forEach((key, value) -> {
                String aliasName = this.headerAlias.get(StrUtil.toString(key));
                if (aliasName != null) {
                    filteredTable.put(key, aliasName, value);
                    return;
                }
                if (!this.onlyAlias) {
                    void var3_3;
                    void var1_1;
                    void var2_2;
                    void v0 = var2_2;
                    var1_1.put(v0, v0, var3_3);
                }
            });
        }
        return var2_2;
    }

    private Comparator<String> getCachedAliasComparator() {
        IndexedComparator<String> indexedComparator;
        if (MapUtil.isEmpty(this.headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (aliasComparator == null) {
            Set<String> keySet = this.headerAlias.keySet();
            indexedComparator = new IndexedComparator<String>(indexedComparator.toArray(new String[0]));
            this.aliasComparator = indexedComparator;
        }
        return indexedComparator;
    }
}

