/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.poi.excel.ExcelBase;
import cn.hutool.poi.excel.ExcelExtractorUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.WorkbookUtil;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellHandler;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.reader.BeanSheetReader;
import cn.hutool.poi.excel.reader.ColumnSheetReader;
import cn.hutool.poi.excel.reader.ListSheetReader;
import cn.hutool.poi.excel.reader.MapSheetReader;
import cn.hutool.poi.excel.reader.SheetReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;

    /*
     * WARNING - void declaration
     */
    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileUtil.file((String)var1_1), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(String excelFilePath, String sheetName) {
        this(FileUtil.file((String)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookUtil.createBook(bookFile, true), (int)var2_2);
        void var1_1;
        void var2_2;
        this.destFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookUtil.createBook(bookFile, true), (String)var2_2);
        void var1_1;
        void var2_2;
        this.destFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorkbookUtil.createBook((InputStream)var1_1), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorkbookUtil.createBook((InputStream)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(Workbook book, int sheetIndex) {
        this(ExcelReader.getSheetOrCloseWorkbook((Workbook)var1_1, (int)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(Workbook book, String sheetName) {
        this(ExcelReader.getSheetOrCloseWorkbook((Workbook)var1_1, (String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader(Sheet sheet) {
        super((Sheet)var1_1);
        void var1_1;
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        void var1_1;
        this.ignoreEmptyRow = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExcelReader setCellEditor(CellEditor cellEditor) {
        void var1_1;
        this.cellEditor = var1_1;
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    /*
     * WARNING - void declaration
     */
    public List<List<Object>> read(int startRowIndex) {
        void var1_1;
        return this.read((int)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        void var2_2;
        void var1_1;
        return this.read((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        void var1_2;
        void var3_4;
        void var2_3;
        ListSheetReader reader = new ListSheetReader(startRowIndex, (int)var2_3, (boolean)var3_4);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read((SheetReader)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> readColumn(int columnIndex, int startRowIndex) {
        void var2_2;
        void var1_1;
        return this.readColumn((int)var1_1, (int)var2_2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> readColumn(int columnIndex, int startRowIndex, int endRowIndex) {
        void var1_2;
        void var3_4;
        void var2_3;
        ColumnSheetReader reader = new ColumnSheetReader(columnIndex, (int)var2_3, (int)var3_4);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read((SheetReader)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public void read(CellHandler cellHandler) {
        void var1_1;
        this.read(0, Integer.MAX_VALUE, (CellHandler)var1_1);
    }

    public void read(int startRowIndex, int endRowIndex, CellHandler cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            if (row == null) continue;
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell;
                Cell cell2 = cell = row.getCell((int)x);
                cellHandler.handle(cell2, CellUtil.getCellValue(cell2));
            }
        }
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        void var1_2;
        void var3_4;
        void var2_3;
        MapSheetReader reader = new MapSheetReader(headerRowIndex, (int)var2_3, (int)var3_4);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read((SheetReader)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> readAll(Class<T> beanType) {
        void var1_1;
        return this.read(0, 1, Integer.MAX_VALUE, (Class<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.read((int)var1_1, (int)var2_2, Integer.MAX_VALUE, (Class<T>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        void var1_2;
        void var3_4;
        void var2_3;
        BeanSheetReader<T> reader = new BeanSheetReader<T>(headerRowIndex, (int)var2_3, (int)var3_4, beanType);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read((SheetReader<T>)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T read(SheetReader<T> sheetReader) {
        void var1_1;
        this.checkNotClosed();
        return ((SheetReader)Assert.notNull(var1_1)).read(this.sheet);
    }

    /*
     * WARNING - void declaration
     */
    public String readAsText(boolean withSheetName) {
        void var1_1;
        return ExcelExtractorUtil.readAsText(this.workbook, (boolean)var1_1);
    }

    public ExcelExtractor getExtractor() {
        return ExcelExtractorUtil.getExtractor(this.workbook);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> readRow(int rowIndex) {
        void var1_1;
        ExcelReader excelReader = this;
        return excelReader.readRow(excelReader.sheet.getRow((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Object readCellValue(int x, int y) {
        void var2_2;
        void var1_1;
        return CellUtil.getCellValue(this.getCell((int)var1_1, (int)var2_2), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        if (null == this.destFile) {
            return new ExcelWriter(this.sheet);
        }
        return ExcelUtil.getWriter(this.destFile, this.sheet.getSheetName());
    }

    private List<Object> readRow(Row row) {
        return RowUtil.readRow(row, this.cellEditor);
    }

    private void checkNotClosed() {
        Assert.isFalse(this.isClosed, "ExcelReader has been closed!", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, String name) throws IllegalArgumentException {
        void var2_2;
        Sheet sheet;
        Assert.notNull(workbook);
        if (name == null) {
            name = "sheet1";
        }
        if ((sheet = workbook.getSheet(name)) == null) {
            void var1_1;
            Workbook workbook2;
            IoUtil.close((Closeable)workbook2);
            throw new IllegalArgumentException("Sheet [" + (String)var1_1 + "] not exist!");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, int sheetIndex) throws IllegalArgumentException {
        void var2_3;
        Sheet sheet;
        Assert.notNull(workbook);
        try {
            sheet = workbook.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException e) {
            void var1_2;
            IoUtil.close((Closeable)workbook);
            throw var1_2;
        }
        if (sheet == null) {
            void var1_1;
            Workbook workbook2;
            IoUtil.close((Closeable)workbook2);
            throw new IllegalArgumentException("Sheet at [" + (int)var1_1 + "] not exist!");
        }
        return var2_3;
    }
}

