/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelPicUtil {
    /*
     * WARNING - void declaration
     */
    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Workbook workbook2;
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return ExcelPicUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            void var1_1;
            return ExcelPicUtil.getPicMapXlsx((XSSFWorkbook)workbook, (int)var1_1);
        }
        throw new IllegalArgumentException(StrUtil.format("Workbook type [{}] is not supported!", workbook2.getClass()));
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        void var2_2;
        HashMap picMap = new HashMap();
        List pictures = workbook.getAllPictures();
        if (CollectionUtil.isNotEmpty(pictures)) {
            workbook = workbook.getSheetAt(sheetIndex);
            for (HSSFWorkbook shape : workbook.getDrawingPatriarch().getChildren()) {
                void var1_1;
                HSSFWorkbook hSSFWorkbook;
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFWorkbook anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StrUtil.format("{}_{}", anchor.getRow1(), hSSFWorkbook.getCol1()), pictures.get((int)var1_1));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        void var2_3;
        void var1_1;
        LinkedHashMap<String, XSSFPictureData> sheetIndexPicMap = new LinkedHashMap<String, XSSFPictureData>();
        workbook = workbook.getSheetAt((int)var1_1);
        for (Object dr : workbook.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            dr = (XSSFDrawing)dr;
            dr = dr.getShapes();
            for (Object shape : dr) {
                Object object;
                void var3_4;
                if (!(shape instanceof XSSFPicture)) continue;
                Object pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StrUtil.format("{}_{}", ctMarker.getRow(), var3_4.getCol()), object.getPictureData());
            }
        }
        return var2_3;
    }
}

