/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.WorkbookUtil;
import cn.hutool.poi.excel.cell.CellLocation;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.StyleUtil;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelBase<T extends ExcelBase<T>>
implements Closeable {
    protected boolean isClosed;
    protected File destFile;
    protected Workbook workbook;
    protected Sheet sheet;
    protected Map<String, String> headerAlias;

    /*
     * WARNING - void declaration
     */
    public ExcelBase(Sheet sheet) {
        void var1_1;
        Assert.notNull(sheet, "No Sheet provided.", new Object[0]);
        this.sheet = sheet;
        this.workbook = var1_1.getWorkbook();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getSheetCount() {
        return this.workbook.getNumberOfSheets();
    }

    /*
     * WARNING - void declaration
     */
    public List<Sheet> getSheets() {
        void var2_2;
        int totalSheet = this.getSheetCount();
        ArrayList<Sheet> result = new ArrayList<Sheet>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getSheetNames() {
        void var2_2;
        int totalSheet = this.workbook.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return var2_2;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    /*
     * WARNING - void declaration
     */
    public T renameSheet(String newName) {
        void var1_1;
        this.workbook.setSheetName(this.workbook.getSheetIndex(this.sheet), (String)var1_1);
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T setSheet(String sheetName) {
        void var1_1;
        ExcelBase excelBase = this;
        return excelBase.setSheet(WorkbookUtil.getOrCreateSheet(excelBase.workbook, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public T setSheet(int sheetIndex) {
        void var1_1;
        ExcelBase excelBase = this;
        return excelBase.setSheet(WorkbookUtil.getOrCreateSheet(excelBase.workbook, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public T setSheet(Sheet sheet) {
        void var1_1;
        this.sheet = var1_1;
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T cloneSheet(int sheetIndex, String newSheetName, boolean setAsCurrentSheet) {
        void var3_4;
        Sheet sheet2;
        if (this.workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xSSFWorkbook = (XSSFWorkbook)this.workbook;
            sheet2 = xSSFWorkbook.cloneSheet(sheetIndex, newSheetName);
        } else {
            void var2_3;
            void sheet;
            sheet2 = this.workbook.cloneSheet((int)sheet);
            this.workbook.setSheetName(this.workbook.getSheetIndex(sheet2), (String)var2_3);
        }
        if (var3_4 != false) {
            void var1_2;
            this.sheet = var1_2;
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public Cell getCell(String locationRef) {
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.getCell(cellLocation.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public Cell getCell(int x, int y) {
        void var2_2;
        void var1_1;
        return this.getCell((int)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public Cell getOrCreateCell(String locationRef) {
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.getOrCreateCell(cellLocation.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public Cell getOrCreateCell(int x, int y) {
        void var2_2;
        void var1_1;
        return this.getCell((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public Cell getCell(String locationRef, boolean isCreateIfNotExist) {
        void var2_2;
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.getCell(cellLocation.getX(), var1_1.getY(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Cell getCell(int x, int y, boolean isCreateIfNotExist) {
        Row row;
        Row row2 = row = isCreateIfNotExist ? RowUtil.getOrCreateRow(this.sheet, y) : this.sheet.getRow(y);
        if (row != null) {
            void var1_1;
            void var2_3;
            void var3_4;
            if (var3_4 != false) {
                return CellUtil.getOrCreateCell(row, x);
            }
            return var2_3.getCell((int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Row getOrCreateRow(int y) {
        void var1_1;
        return RowUtil.getOrCreateRow(this.sheet, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getOrCreateCellStyle(String locationRef) {
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.getOrCreateCellStyle(cellLocation.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getOrCreateCellStyle(int x, int y) {
        void var3_3;
        CellStyle cellStyle = this.getOrCreateCell(x, y).getCellStyle();
        if (StyleUtil.isNullOrDefaultStyle(this.workbook, cellStyle)) {
            void var2_2;
            void var1_1;
            return this.createCellStyle((int)var1_1, (int)var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle createCellStyle(String locationRef) {
        void var1_1;
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return this.createCellStyle(cellLocation.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle createCellStyle(int x, int y) {
        void var2_4;
        void var1_2;
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = this.workbook.createCellStyle();
        var1_2.setCellStyle(cellStyle);
        return var2_4;
    }

    public CellStyle createCellStyle() {
        return StyleUtil.createCellStyle(this.workbook);
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getOrCreateRowStyle(int y) {
        void var2_2;
        CellStyle rowStyle = this.getOrCreateRow(y).getRowStyle();
        if (StyleUtil.isNullOrDefaultStyle(this.workbook, rowStyle)) {
            void var1_1;
            return this.createRowStyle((int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle createRowStyle(int y) {
        void var2_2;
        void var1_1;
        CellStyle rowStyle = this.workbook.createCellStyle();
        this.getOrCreateRow((int)var1_1).setRowStyle(rowStyle);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getOrCreateColumnStyle(int x) {
        void var2_2;
        CellStyle columnStyle = this.sheet.getColumnStyle(x);
        if (StyleUtil.isNullOrDefaultStyle(this.workbook, columnStyle)) {
            void var1_1;
            return this.createColumnStyle((int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle createColumnStyle(int x) {
        void var2_2;
        void var1_1;
        CellStyle columnStyle = this.workbook.createCellStyle();
        this.sheet.setDefaultColumnStyle((int)var1_1, columnStyle);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Hyperlink createHyperlink(HyperlinkType type, String address) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        return this.createHyperlink((HyperlinkType)var1_1, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    public Hyperlink createHyperlink(HyperlinkType type, String address, String label) {
        void var1_1;
        void var3_3;
        void var2_2;
        Hyperlink hyperlink = this.workbook.getCreationHelper().createHyperlink(type);
        hyperlink.setAddress((String)var2_2);
        hyperlink.setLabel((String)var3_3);
        return var1_1;
    }

    public int getRowCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getPhysicalRowCount() {
        return this.sheet.getPhysicalNumberOfRows();
    }

    public int getColumnCount() {
        return this.getColumnCount(0);
    }

    /*
     * WARNING - void declaration
     */
    public int getColumnCount(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row != null) {
            void var1_2;
            return var1_2.getLastCellNum();
        }
        return -1;
    }

    public boolean isXlsx() {
        return this.sheet instanceof XSSFSheet || this.sheet instanceof SXSSFSheet;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.workbook);
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    /*
     * WARNING - void declaration
     */
    public T setHeaderAlias(Map<String, String> headerAlias) {
        void var1_1;
        this.headerAlias = var1_1;
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T addHeaderAlias(String header, String alias) {
        void var2_2;
        void var1_1;
        void var3_3;
        Map<String, String> headerAlias = this.headerAlias;
        if (headerAlias == null) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = var3_3;
        this.headerAlias.put((String)var1_1, (String)var2_2);
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T removeHeaderAlias(String header) {
        void var1_1;
        this.headerAlias.remove(var1_1);
        return (T)this;
    }

    public T clearHeaderAlias() {
        this.headerAlias = null;
        return (T)this;
    }
}

